/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;

public abstract class KotlinDetector {
    @Nullable
    private static final Class<? extends Annotation> kotlinMetadata;
    @Nullable
    private static final Class<? extends Annotation> kotlinJvmInline;
    private static final boolean kotlinPresent;
    private static final boolean kotlinReflectPresent;

    public static boolean isKotlinPresent() {
        return kotlinPresent;
    }

    public static boolean isKotlinReflectPresent() {
        return kotlinReflectPresent;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    public static boolean isSuspendingFunction(Method method) {
        Class<?>[] types;
        return KotlinDetector.isKotlinType(method.getDeclaringClass()) && (types = method.getParameterTypes()).length > 0 && "kotlin.coroutines.Continuation".equals(types[types.length - 1].getName());
    }

    public static boolean isInlineClass(Class<?> clazz) {
        return kotlinJvmInline != null && clazz.getDeclaredAnnotation(kotlinJvmInline) != null;
    }

    static {
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        Class<?> metadata = null;
        Class<?> jvmInline = null;
        try {
            metadata = ClassUtils.forName("kotlin.Metadata", classLoader);
            try {
                jvmInline = ClassUtils.forName("kotlin.jvm.JvmInline", classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        kotlinMetadata = metadata;
        kotlinPresent = kotlinMetadata != null;
        kotlinReflectPresent = kotlinPresent && ClassUtils.isPresent("kotlin.reflect.full.KClasses", classLoader);
        kotlinJvmInline = jvmInline;
    }
}

