/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.Executor;
import keycloakjar.org.springframework.core.task.SimpleAsyncTaskExecutor;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.client.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.JdkClientHttpRequest;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public class JdkClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient httpClient;
    private final Executor executor;
    @Nullable
    private Duration readTimeout;

    public JdkClientHttpRequestFactory() {
        this(HttpClient.newHttpClient());
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        this.httpClient = httpClient;
        this.executor = httpClient.executor().orElseGet(SimpleAsyncTaskExecutor::new);
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient, Executor executor) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        Assert.notNull((Object)executor, "Executor must not be null");
        this.httpClient = httpClient;
        this.executor = executor;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new JdkClientHttpRequest(this.httpClient, uri, httpMethod, this.executor, this.readTimeout);
    }
}

