/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.objenesis.strategy;

import java.io.NotSerializableException;
import java.io.Serializable;
import keycloakjar.org.springframework.objenesis.ObjenesisException;
import keycloakjar.org.springframework.objenesis.instantiator.ObjectInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.android.AndroidSerializationInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.perc.PercSerializationInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import keycloakjar.org.springframework.objenesis.strategy.BaseInstantiatorStrategy;
import keycloakjar.org.springframework.objenesis.strategy.PlatformDescription;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            return new SunReflectionFactorySerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new SunReflectionFactorySerializationInstantiator<T>(type);
    }
}

