/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import keycloakjar.org.springframework.lang.Nullable;

public class BooleanComparator
implements Comparator<Boolean>,
Serializable {
    public static final BooleanComparator TRUE_LOW = new BooleanComparator(true);
    public static final BooleanComparator TRUE_HIGH = new BooleanComparator(false);
    private final boolean trueLow;

    public BooleanComparator(boolean trueLow) {
        this.trueLow = trueLow;
    }

    @Override
    public int compare(Boolean left, Boolean right) {
        int multiplier = this.trueLow ? -1 : 1;
        return multiplier * Boolean.compare(left, right);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof BooleanComparator)) return false;
        BooleanComparator that = (BooleanComparator)other;
        if (this.trueLow != that.trueLow) return false;
        return true;
    }

    public int hashCode() {
        return Boolean.hashCode(this.trueLow);
    }

    public String toString() {
        return "BooleanComparator: " + (this.trueLow ? "true low" : "true high");
    }
}

