/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web;

import jakarta.servlet.ServletException;
import java.util.Collections;
import java.util.List;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ProblemDetail;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.ErrorResponse;

public abstract class HttpMediaTypeException
extends ServletException
implements ErrorResponse {
    private final List<MediaType> supportedMediaTypes;
    private final ProblemDetail body = ProblemDetail.forStatus(this.getStatusCode());
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    @Deprecated
    protected HttpMediaTypeException(String message) {
        this(message, Collections.emptyList());
    }

    @Deprecated
    protected HttpMediaTypeException(String message, List<MediaType> supportedMediaTypes) {
        this(message, supportedMediaTypes, null, null);
    }

    protected HttpMediaTypeException(@Nullable String message, List<MediaType> supportedMediaTypes, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(message);
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
        this.messageDetailCode = messageDetailCode != null ? messageDetailCode : ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
        this.messageDetailArguments = messageDetailArguments;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    @Nullable
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }
}

