/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.converter.HttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.web.client.DefaultResponseErrorHandler;
import keycloakjar.org.springframework.web.client.HttpMessageConverterExtractor;
import keycloakjar.org.springframework.web.client.RestClientException;

public class ExtractingResponseErrorHandler
extends DefaultResponseErrorHandler {
    private List<HttpMessageConverter<?>> messageConverters = Collections.emptyList();
    private final Map<HttpStatusCode, Class<? extends RestClientException>> statusMapping = new LinkedHashMap<HttpStatusCode, Class<? extends RestClientException>>();
    private final Map<HttpStatus.Series, Class<? extends RestClientException>> seriesMapping = new LinkedHashMap<HttpStatus.Series, Class<? extends RestClientException>>();

    public ExtractingResponseErrorHandler() {
    }

    public ExtractingResponseErrorHandler(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Override
    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setStatusMapping(Map<HttpStatusCode, Class<? extends RestClientException>> statusMapping) {
        if (!CollectionUtils.isEmpty(statusMapping)) {
            this.statusMapping.putAll(statusMapping);
        }
    }

    public void setSeriesMapping(Map<HttpStatus.Series, Class<? extends RestClientException>> seriesMapping) {
        if (!CollectionUtils.isEmpty(seriesMapping)) {
            this.seriesMapping.putAll(seriesMapping);
        }
    }

    @Override
    protected boolean hasError(HttpStatusCode statusCode) {
        if (this.statusMapping.containsKey(statusCode)) {
            return this.statusMapping.get(statusCode) != null;
        }
        HttpStatus.Series series = HttpStatus.Series.resolve(statusCode.value());
        if (this.seriesMapping.containsKey((Object)series)) {
            return this.seriesMapping.get((Object)series) != null;
        }
        return super.hasError(statusCode);
    }

    @Override
    public void handleError(ClientHttpResponse response, HttpStatusCode statusCode) throws IOException {
        HttpStatus.Series series;
        if (this.statusMapping.containsKey(statusCode)) {
            this.extract(this.statusMapping.get(statusCode), response);
        }
        if (this.seriesMapping.containsKey((Object)(series = HttpStatus.Series.resolve(statusCode.value())))) {
            this.extract(this.seriesMapping.get((Object)series), response);
        } else {
            super.handleError(response, statusCode);
        }
    }

    private void extract(@Nullable Class<? extends RestClientException> exceptionClass, ClientHttpResponse response) throws IOException {
        if (exceptionClass == null) {
            return;
        }
        HttpMessageConverterExtractor<? extends RestClientException> extractor = new HttpMessageConverterExtractor<RestClientException>(exceptionClass, this.messageConverters);
        RestClientException exception = extractor.extractData(response);
        if (exception != null) {
            throw exception;
        }
    }
}

