/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpRequest;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.converter.HttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.web.client.ClientHttpResponseDecorator;
import keycloakjar.org.springframework.web.client.HttpClientErrorException;
import keycloakjar.org.springframework.web.client.HttpMessageConverterExtractor;
import keycloakjar.org.springframework.web.client.HttpServerErrorException;
import keycloakjar.org.springframework.web.client.ResponseErrorHandler;
import keycloakjar.org.springframework.web.client.RestClient;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.client.RestClientResponseException;
import keycloakjar.org.springframework.web.client.RestClientUtils;
import keycloakjar.org.springframework.web.client.UnknownHttpStatusCodeException;

final class StatusHandler {
    private final ResponsePredicate predicate;
    private final RestClient.ResponseSpec.ErrorHandler errorHandler;

    private StatusHandler(ResponsePredicate predicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        this.predicate = predicate;
        this.errorHandler = errorHandler;
    }

    public static StatusHandler of(Predicate<HttpStatusCode> predicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        Assert.notNull(predicate, "Predicate must not be null");
        Assert.notNull((Object)errorHandler, "ErrorHandler must not be null");
        return new StatusHandler(response -> predicate.test(response.getStatusCode()), errorHandler);
    }

    public static StatusHandler fromErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, "ResponseErrorHandler must not be null");
        return new StatusHandler(errorHandler::hasError, (request, response) -> errorHandler.handleError(request.getURI(), request.getMethod(), response));
    }

    public static StatusHandler defaultHandler(List<HttpMessageConverter<?>> messageConverters) {
        return new StatusHandler(response -> response.getStatusCode().isError(), (request, response) -> {
            HttpStatusCode statusCode = response.getStatusCode();
            String statusText = response.getStatusText();
            HttpHeaders headers = response.getHeaders();
            byte[] body2 = RestClientUtils.getBody(response);
            Charset charset = RestClientUtils.getCharset(response);
            String message = StatusHandler.getErrorMessage(statusCode.value(), statusText, body2, charset);
            RestClientResponseException ex = statusCode.is4xxClientError() ? HttpClientErrorException.create(message, statusCode, statusText, headers, body2, charset) : (statusCode.is5xxServerError() ? HttpServerErrorException.create(message, statusCode, statusText, headers, body2, charset) : new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body2, charset));
            if (!CollectionUtils.isEmpty(messageConverters)) {
                ex.setBodyConvertFunction(StatusHandler.initBodyConvertFunction(response, body2, messageConverters));
            }
            throw ex;
        });
    }

    private static Function<ResolvableType, ?> initBodyConvertFunction(ClientHttpResponse response, final byte[] body2, List<HttpMessageConverter<?>> messageConverters) {
        Assert.state(!CollectionUtils.isEmpty(messageConverters), "Expected message converters");
        return resolvableType -> {
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(resolvableType.getType(), messageConverters);
                return extractor.extractData(new ClientHttpResponseDecorator(response){

                    @Override
                    public InputStream getBody() {
                        return new ByteArrayInputStream(body2);
                    }
                });
            }
            catch (IOException ex) {
                throw new RestClientException("Error while extracting response for type [" + resolvableType + "]", ex);
            }
        };
    }

    private static String getErrorMessage(int rawStatusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset charset) {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtils.isEmpty((Object)responseBody)) {
            return preface + "[no body]";
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        String bodyText = new String(responseBody, charset);
        bodyText = LogFormatUtils.formatValue(bodyText, -1, true);
        return preface + bodyText;
    }

    public boolean test(ClientHttpResponse response) throws IOException {
        return this.predicate.test(response);
    }

    public void handle(HttpRequest request, ClientHttpResponse response) throws IOException {
        this.errorHandler.handle(request, response);
    }

    @FunctionalInterface
    private static interface ResponsePredicate {
        public boolean test(ClientHttpResponse var1) throws IOException;
    }
}

