/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.cors.reactive;

import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.cors.reactive.CorsUtils;
import keycloakjar.org.springframework.web.cors.reactive.PreFlightRequestHandler;
import keycloakjar.org.springframework.web.server.ServerWebExchange;
import keycloakjar.org.springframework.web.server.WebFilter;
import keycloakjar.org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class PreFlightRequestWebFilter
implements WebFilter {
    private final PreFlightRequestHandler handler;

    public PreFlightRequestWebFilter(PreFlightRequestHandler handler) {
        Assert.notNull((Object)handler, "PreFlightRequestHandler is required");
        this.handler = handler;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return CorsUtils.isPreFlightRequest(exchange2.getRequest()) ? this.handler.handlePreFlight(exchange2) : chain.filter(exchange2);
    }
}

