/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.annotation;

import java.util.Collections;
import java.util.List;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.bind.annotation.InitBinder;
import keycloakjar.org.springframework.web.bind.support.DefaultDataBinderFactory;
import keycloakjar.org.springframework.web.bind.support.WebBindingInitializer;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.method.HandlerMethod;
import keycloakjar.org.springframework.web.method.support.InvocableHandlerMethod;

public class InitBinderDataBinderFactory
extends DefaultDataBinderFactory {
    private final List<InvocableHandlerMethod> binderMethods;

    public InitBinderDataBinderFactory(@Nullable List<InvocableHandlerMethod> binderMethods, @Nullable WebBindingInitializer initializer) {
        super(initializer);
        this.binderMethods = binderMethods != null ? binderMethods : Collections.emptyList();
    }

    @Override
    public void initBinder(WebDataBinder dataBinder, NativeWebRequest request) throws Exception {
        for (InvocableHandlerMethod binderMethod : this.binderMethods) {
            Object returnValue;
            if (!this.isBinderMethodApplicable(binderMethod, dataBinder) || (returnValue = binderMethod.invokeForRequest(request, null, new Object[]{dataBinder})) == null) continue;
            throw new IllegalStateException("@InitBinder methods must not return a value (should be void): " + binderMethod);
        }
    }

    protected boolean isBinderMethodApplicable(HandlerMethod initBinderMethod, WebDataBinder dataBinder) {
        InitBinder ann = initBinderMethod.getMethodAnnotation(InitBinder.class);
        Assert.state(ann != null, "No InitBinder annotation");
        Object[] names = ann.value();
        return ObjectUtils.isEmpty(names) || ObjectUtils.containsElement(names, dataBinder.getObjectName());
    }
}

