/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.server.adapter;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.server.reactive.ServerHttpRequest;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.LinkedCaseInsensitiveMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.util.ForwardedHeaderUtils;
import keycloakjar.org.springframework.web.util.UriComponents;

public class ForwardedHeaderTransformer
implements Function<ServerHttpRequest, ServerHttpRequest> {
    static final Set<String> FORWARDED_HEADER_NAMES = Collections.newSetFromMap(new LinkedCaseInsensitiveMap<Boolean>(10, Locale.ENGLISH));
    private boolean removeOnly;

    public void setRemoveOnly(boolean removeOnly) {
        this.removeOnly = removeOnly;
    }

    public boolean isRemoveOnly() {
        return this.removeOnly;
    }

    @Override
    public ServerHttpRequest apply(ServerHttpRequest request) {
        if (this.hasForwardedHeaders(request)) {
            ServerHttpRequest.Builder builder = request.mutate();
            if (!this.removeOnly) {
                URI originalUri = request.getURI();
                HttpHeaders headers = request.getHeaders();
                URI uri = ForwardedHeaderTransformer.adaptFromForwardedHeaders(originalUri, headers);
                builder.uri(uri);
                String prefix = ForwardedHeaderTransformer.getForwardedPrefix(request);
                if (prefix != null) {
                    builder.path(prefix + uri.getRawPath());
                    builder.contextPath(prefix);
                }
                InetSocketAddress remoteAddress = request.getRemoteAddress();
                if ((remoteAddress = ForwardedHeaderUtils.parseForwardedFor(originalUri, headers, remoteAddress)) != null) {
                    builder.remoteAddress(remoteAddress);
                }
            }
            this.removeForwardedHeaders(builder);
            request = builder.build();
        }
        return request;
    }

    private static URI adaptFromForwardedHeaders(URI uri, HttpHeaders headers) {
        UriComponents components = ForwardedHeaderUtils.adaptFromForwardedHeaders(uri, headers).build();
        try {
            return new URI(components.toUriString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }

    protected boolean hasForwardedHeaders(ServerHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        for (String headerName : FORWARDED_HEADER_NAMES) {
            if (!headers.containsKey(headerName)) continue;
            return true;
        }
        return false;
    }

    private void removeForwardedHeaders(ServerHttpRequest.Builder builder) {
        builder.headers(map -> FORWARDED_HEADER_NAMES.forEach(map::remove));
    }

    @Nullable
    private static String getForwardedPrefix(ServerHttpRequest request) {
        String[] rawPrefixes;
        HttpHeaders headers = request.getHeaders();
        String header = headers.getFirst("X-Forwarded-Prefix");
        if (header == null) {
            return null;
        }
        StringBuilder prefix = new StringBuilder(header.length());
        for (String rawPrefix : rawPrefixes = StringUtils.tokenizeToStringArray(header, ",")) {
            int endIndex;
            for (endIndex = rawPrefix.length(); endIndex > 0 && rawPrefix.charAt(endIndex - 1) == '/'; --endIndex) {
            }
            prefix.append(endIndex != rawPrefix.length() ? rawPrefix.substring(0, endIndex) : rawPrefix);
        }
        return prefix.toString();
    }

    static {
        FORWARDED_HEADER_NAMES.add("Forwarded");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Prefix");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Ssl");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-For");
    }
}

