/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.io.micrometer.observation;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import keycloakjar.io.micrometer.common.lang.Nullable;
import keycloakjar.io.micrometer.observation.Observation;
import keycloakjar.io.micrometer.observation.ObservationRegistry;

public final class Observations {
    private static final ObservationRegistry initialRegistry = ObservationRegistry.create();
    private static final DelegatingObservationRegistry globalRegistry = new DelegatingObservationRegistry(initialRegistry);

    private Observations() {
    }

    public static void setRegistry(ObservationRegistry registry) {
        globalRegistry.setDelegate(registry);
    }

    public static void resetRegistry() {
        globalRegistry.setDelegate(initialRegistry);
    }

    public static ObservationRegistry getGlobalRegistry() {
        return globalRegistry;
    }

    private static final class DelegatingObservationRegistry
    implements ObservationRegistry {
        private final AtomicReference<ObservationRegistry> delegate = new AtomicReference<ObservationRegistry>(ObservationRegistry.NOOP);

        DelegatingObservationRegistry(ObservationRegistry delegate) {
            this.setDelegate(delegate);
        }

        void setDelegate(ObservationRegistry delegate) {
            this.delegate.set(Objects.requireNonNull(delegate, "Delegate must not be null"));
        }

        @Override
        @Nullable
        public Observation getCurrentObservation() {
            return this.delegate.get().getCurrentObservation();
        }

        @Override
        @Nullable
        public Observation.Scope getCurrentObservationScope() {
            return this.delegate.get().getCurrentObservationScope();
        }

        @Override
        public void setCurrentObservationScope(@Nullable Observation.Scope current) {
            this.delegate.get().setCurrentObservationScope(current);
        }

        @Override
        public ObservationRegistry.ObservationConfig observationConfig() {
            return this.delegate.get().observationConfig();
        }

        @Override
        public boolean isNoop() {
            return this.delegate.get().isNoop();
        }
    }
}

