/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.entity;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class DeflateInputStream
extends FilterInputStream {
    public DeflateInputStream(InputStream wrapped) throws IOException {
        super(null);
        PushbackInputStream pushback = new PushbackInputStream(wrapped, 2);
        int i1 = pushback.read();
        int i2 = pushback.read();
        if (i1 == -1 || i2 == -1) {
            throw new ZipException("Unexpected end of stream");
        }
        pushback.unread(i2);
        pushback.unread(i1);
        boolean nowrap = true;
        int b1 = i1 & 0xFF;
        int compressionMethod = b1 & 0xF;
        int compressionInfo = b1 >> 4 & 0xF;
        int b2 = i2 & 0xFF;
        if (compressionMethod == 8 && compressionInfo <= 7 && (b1 << 8 | b2) % 31 == 0) {
            nowrap = false;
        }
        this.in = new DeflateStream((InputStream)pushback, new Inflater(nowrap));
    }

    private static class DeflateStream
    extends InflaterInputStream {
        private boolean closed;

        private DeflateStream(InputStream in, Inflater inflater) {
            super(in, inflater);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.inf.end();
            super.close();
        }
    }
}

