/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.impl.async;

import java.util.concurrent.Future;
import keycloakjar.org.apache.hc.client5.http.async.HttpAsyncClient;
import keycloakjar.org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import keycloakjar.org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import keycloakjar.org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import keycloakjar.org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.concurrent.FutureCallback;
import keycloakjar.org.apache.hc.core5.function.Supplier;
import keycloakjar.org.apache.hc.core5.http.HttpHost;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import keycloakjar.org.apache.hc.core5.http.nio.HandlerFactory;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.apache.hc.core5.io.ModalCloseable;
import keycloakjar.org.apache.hc.core5.reactor.IOReactorStatus;
import keycloakjar.org.apache.hc.core5.util.Args;
import keycloakjar.org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
ModalCloseable {
    public abstract void start();

    public abstract IOReactorStatus getStatus();

    public abstract void awaitShutdown(TimeValue var1) throws InterruptedException;

    public abstract void initiateShutdown();

    protected abstract <T> Future<T> doExecute(HttpHost var1, AsyncRequestProducer var2, AsyncResponseConsumer<T> var3, HandlerFactory<AsyncPushConsumer> var4, HttpContext var5, FutureCallback<T> var6);

    public final <T> Future<T> execute(HttpHost target, AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.doExecute(target, requestProducer, responseConsumer, pushHandlerFactory, context, callback);
    }

    @Override
    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.doExecute(null, requestProducer, responseConsumer, pushHandlerFactory, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.execute(requestProducer, responseConsumer, null, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.execute(requestProducer, responseConsumer, null, callback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request, HttpContext context, FutureCallback<SimpleHttpResponse> callback) {
        Args.notNull(request, "Request");
        return this.execute(SimpleRequestProducer.create(request), SimpleResponseConsumer.create(), context, callback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request, FutureCallback<SimpleHttpResponse> callback) {
        return this.execute(request, null, callback);
    }

    @Deprecated
    public abstract void register(String var1, String var2, Supplier<AsyncPushConsumer> var3);

    @Deprecated
    public final void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.register(null, uriPattern, supplier);
    }
}

