/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http;

import keycloakjar.org.apache.hc.core5.annotation.Internal;
import keycloakjar.org.apache.hc.core5.http.ParseException;
import keycloakjar.org.apache.hc.core5.http.ProtocolVersion;
import keycloakjar.org.apache.hc.core5.util.TextUtils;
import keycloakjar.org.apache.hc.core5.util.Tokenizer;

@Internal
public class ProtocolVersionParser {
    public static final ProtocolVersionParser INSTANCE = new ProtocolVersionParser();
    private static final char SLASH = '/';
    private static final char FULL_STOP = '.';
    private static final Tokenizer.Delimiter PROTO_DELIMITER = Tokenizer.delimiters('/');
    private static final Tokenizer.Delimiter FULL_STOP_OR_BLANK = Tokenizer.delimiters('.', ' ', '\t');
    private static final Tokenizer.Delimiter BLANK = Tokenizer.delimiters(' ', '\t');
    private final Tokenizer tokenizer = Tokenizer.INSTANCE;

    public ProtocolVersion parse(String protocol, Factory factory, CharSequence buffer, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        int minor;
        int major;
        int lowerBound = cursor.getLowerBound();
        int upperBound = cursor.getUpperBound();
        String token1 = this.tokenizer.parseToken(buffer, cursor, delimiterPredicate != null ? ch -> delimiterPredicate.test(ch) || FULL_STOP_OR_BLANK.test(ch) : FULL_STOP_OR_BLANK);
        try {
            major = Integer.parseInt(token1);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid " + protocol + " major version number", buffer, lowerBound, upperBound, cursor.getPos());
        }
        if (cursor.atEnd()) {
            return factory != null ? factory.create(major, major) : new ProtocolVersion(protocol, major, 0);
        }
        if (buffer.charAt(cursor.getPos()) != '.') {
            return factory != null ? factory.create(major, major) : new ProtocolVersion(protocol, major, 0);
        }
        cursor.updatePos(cursor.getPos() + 1);
        String token2 = this.tokenizer.parseToken(buffer, cursor, delimiterPredicate != null ? ch -> delimiterPredicate.test(ch) || BLANK.test(ch) : BLANK);
        try {
            minor = Integer.parseInt(token2);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid " + protocol + " minor version number", buffer, lowerBound, upperBound, cursor.getPos());
        }
        return factory != null ? factory.create(major, minor) : new ProtocolVersion(protocol, major, minor);
    }

    public ProtocolVersion parse(String protocol, CharSequence buffer, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        return this.parse(protocol, null, buffer, cursor, delimiterPredicate);
    }

    public ProtocolVersion parse(String protocol, CharSequence buffer, Tokenizer.Cursor cursor) throws ParseException {
        return this.parse(protocol, null, buffer, cursor, null);
    }

    public ProtocolVersion parse(CharSequence buffer, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String proto = this.tokenizer.parseToken(buffer, cursor, PROTO_DELIMITER);
        if (TextUtils.isBlank(proto)) {
            throw new ParseException("Invalid protocol name");
        }
        if (!cursor.atEnd() && buffer.charAt(cursor.getPos()) == '/') {
            cursor.updatePos(cursor.getPos() + 1);
            return this.parse(proto, null, buffer, cursor, delimiterPredicate);
        }
        throw new ParseException("Invalid protocol name");
    }

    @FunctionalInterface
    @Internal
    public static interface Factory {
        public ProtocolVersion create(int var1, int var2);
    }
}

