/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.io.ssl;

import javax.net.ssl.SSLParameters;
import keycloakjar.org.apache.hc.core5.function.Callback;
import keycloakjar.org.apache.hc.core5.http.URIScheme;
import keycloakjar.org.apache.hc.core5.http.ssl.TLS;
import keycloakjar.org.apache.hc.core5.http.ssl.TlsCiphers;

public final class DefaultTlsSetupHandler
implements Callback<SSLParameters> {
    public static final DefaultTlsSetupHandler SERVER = new DefaultTlsSetupHandler(false);
    public static final DefaultTlsSetupHandler CLIENT = new DefaultTlsSetupHandler(true);
    private final boolean client;

    public DefaultTlsSetupHandler() {
        this.client = false;
    }

    public DefaultTlsSetupHandler(boolean client) {
        this.client = client;
    }

    @Override
    public void execute(SSLParameters sslParameters) {
        sslParameters.setProtocols(TLS.excludeWeak(sslParameters.getProtocols()));
        sslParameters.setCipherSuites(TlsCiphers.excludeWeak(sslParameters.getCipherSuites()));
        if (this.client) {
            sslParameters.setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
        }
    }
}

