/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.support;

import java.util.concurrent.atomic.AtomicReference;
import keycloakjar.org.apache.hc.core5.annotation.Internal;
import keycloakjar.org.apache.hc.core5.http.EntityDetails;
import keycloakjar.org.apache.hc.core5.http.HttpRequest;
import keycloakjar.org.apache.hc.core5.http.HttpVersion;
import keycloakjar.org.apache.hc.core5.http.ProtocolException;
import keycloakjar.org.apache.hc.core5.http.message.MessageSupport;
import keycloakjar.org.apache.hc.core5.http.support.Expectation;
import keycloakjar.org.apache.hc.core5.util.TextUtils;

@Internal
public class ExpectSupport {
    public static Expectation parse(HttpRequest request, EntityDetails entityDetails) throws ProtocolException {
        if (request.getVersion() != null && request.getVersion().lessEquals(HttpVersion.HTTP_1_0)) {
            return null;
        }
        AtomicReference expectationRef = new AtomicReference();
        MessageSupport.parseTokens(request, "Expect", t2 -> {
            if (t2.equalsIgnoreCase("100-continue")) {
                expectationRef.compareAndSet(null, Expectation.CONTINUE);
            } else if (!TextUtils.isBlank(t2)) {
                expectationRef.set(Expectation.UNKNOWN);
            }
        });
        Expectation expectation = (Expectation)((Object)expectationRef.get());
        if (expectation == Expectation.CONTINUE && entityDetails == null) {
            throw new ProtocolException("Expect-Continue request without an enclosed entity");
        }
        return expectation;
    }
}

