/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import keycloakjar.org.springframework.beans.AbstractNestablePropertyAccessor;
import keycloakjar.org.springframework.beans.InvalidPropertyException;
import keycloakjar.org.springframework.beans.NotWritablePropertyException;
import keycloakjar.org.springframework.beans.PropertyMatches;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.convert.TypeDescriptor;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ReflectionUtils;

public class DirectFieldAccessor
extends AbstractNestablePropertyAccessor {
    private final Map<String, FieldPropertyHandler> fieldMap = new HashMap<String, FieldPropertyHandler>();

    public DirectFieldAccessor(Object object) {
        super(object);
    }

    protected DirectFieldAccessor(Object object, String nestedPath, DirectFieldAccessor parent) {
        super(object, nestedPath, parent);
    }

    @Override
    @Nullable
    protected FieldPropertyHandler getLocalPropertyHandler(String propertyName) {
        Field field;
        FieldPropertyHandler propertyHandler = this.fieldMap.get(propertyName);
        if (propertyHandler == null && (field = ReflectionUtils.findField(this.getWrappedClass(), propertyName)) != null) {
            propertyHandler = new FieldPropertyHandler(field);
            this.fieldMap.put(propertyName, propertyHandler);
        }
        return propertyHandler;
    }

    @Override
    protected DirectFieldAccessor newNestedPropertyAccessor(Object object, String nestedPath) {
        return new DirectFieldAccessor(object, nestedPath, this);
    }

    @Override
    protected NotWritablePropertyException createNotWritablePropertyException(String propertyName) {
        PropertyMatches matches = PropertyMatches.forField(propertyName, this.getRootClass());
        throw new NotWritablePropertyException(this.getRootClass(), this.getNestedPath() + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
    }

    private class FieldPropertyHandler
    extends AbstractNestablePropertyAccessor.PropertyHandler {
        private final Field field;
        private final ResolvableType resolvableType;

        public FieldPropertyHandler(Field field) {
            super(field.getType(), true, true);
            this.field = field;
            this.resolvableType = ResolvableType.forField(this.field);
        }

        @Override
        public TypeDescriptor toTypeDescriptor() {
            return new TypeDescriptor(this.resolvableType, this.field.getType(), this.field.getAnnotations());
        }

        @Override
        public ResolvableType getResolvableType() {
            return this.resolvableType;
        }

        @Override
        public TypeDescriptor getMapValueType(int nestingLevel) {
            return new TypeDescriptor(this.resolvableType.getNested(nestingLevel).asMap().getGeneric(1), null, this.field.getAnnotations());
        }

        @Override
        public TypeDescriptor getCollectionType(int nestingLevel) {
            return new TypeDescriptor(this.resolvableType.getNested(nestingLevel).asCollection().getGeneric(new int[0]), null, this.field.getAnnotations());
        }

        @Override
        @Nullable
        public TypeDescriptor nested(int level) {
            return TypeDescriptor.nested(this.field, level);
        }

        @Override
        @Nullable
        public Object getValue() throws Exception {
            try {
                ReflectionUtils.makeAccessible(this.field);
                return this.field.get(DirectFieldAccessor.this.getWrappedInstance());
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(DirectFieldAccessor.this.getWrappedClass(), this.field.getName(), "Field is not accessible", ex);
            }
        }

        @Override
        public void setValue(@Nullable Object value) throws Exception {
            try {
                ReflectionUtils.makeAccessible(this.field);
                this.field.set(DirectFieldAccessor.this.getWrappedInstance(), value);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(DirectFieldAccessor.this.getWrappedClass(), this.field.getName(), "Field is not accessible", ex);
            }
        }
    }
}

