/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.aot;

import java.util.ArrayList;
import keycloakjar.org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import keycloakjar.org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import keycloakjar.org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationsAotContribution;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import keycloakjar.org.springframework.beans.factory.support.RegisteredBean;
import keycloakjar.org.springframework.lang.Nullable;

class BeanRegistrationsAotProcessor
implements BeanFactoryInitializationAotProcessor {
    BeanRegistrationsAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationsAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory = new BeanDefinitionMethodGeneratorFactory(beanFactory);
        ArrayList<BeanRegistrationsAotContribution.Registration> registrations = new ArrayList<BeanRegistrationsAotContribution.Registration>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            RegisteredBean registeredBean = RegisteredBean.of(beanFactory, beanName);
            BeanDefinitionMethodGenerator beanDefinitionMethodGenerator = beanDefinitionMethodGeneratorFactory.getBeanDefinitionMethodGenerator(registeredBean);
            if (beanDefinitionMethodGenerator == null) continue;
            registrations.add(new BeanRegistrationsAotContribution.Registration(registeredBean, beanDefinitionMethodGenerator, beanFactory.getAliases(beanName)));
        }
        if (registrations.isEmpty()) {
            return null;
        }
        return new BeanRegistrationsAotContribution(registrations);
    }
}

