/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.config;

import java.lang.reflect.Field;
import keycloakjar.org.springframework.beans.factory.BeanClassLoaderAware;
import keycloakjar.org.springframework.beans.factory.BeanFactoryUtils;
import keycloakjar.org.springframework.beans.factory.BeanNameAware;
import keycloakjar.org.springframework.beans.factory.FactoryBean;
import keycloakjar.org.springframework.beans.factory.FactoryBeanNotInitializedException;
import keycloakjar.org.springframework.beans.factory.InitializingBean;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ReflectionUtils;
import keycloakjar.org.springframework.util.StringUtils;

public class FieldRetrievingFactoryBean
implements FactoryBean<Object>,
BeanNameAware,
BeanClassLoaderAware,
InitializingBean {
    @Nullable
    private Class<?> targetClass;
    @Nullable
    private Object targetObject;
    @Nullable
    private String targetField;
    @Nullable
    private String staticField;
    @Nullable
    private String beanName;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private Field fieldObject;

    public void setTargetClass(@Nullable Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Nullable
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(@Nullable Object targetObject) {
        this.targetObject = targetObject;
    }

    @Nullable
    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetField(@Nullable String targetField) {
        this.targetField = targetField != null ? StringUtils.trimAllWhitespace(targetField) : null;
    }

    @Nullable
    public String getTargetField() {
        return this.targetField;
    }

    public void setStaticField(String staticField) {
        this.staticField = StringUtils.trimAllWhitespace(staticField);
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = StringUtils.trimAllWhitespace(BeanFactoryUtils.originalBeanName(beanName));
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchFieldException {
        if (this.targetClass != null && this.targetObject != null) {
            throw new IllegalArgumentException("Specify either targetClass or targetObject, not both");
        }
        if (this.targetClass == null && this.targetObject == null) {
            int lastDotIndex;
            if (this.targetField != null) {
                throw new IllegalArgumentException("Specify targetClass or targetObject in combination with targetField");
            }
            if (this.staticField == null) {
                this.staticField = this.beanName;
                Assert.state(this.staticField != null, "No target field specified");
            }
            if ((lastDotIndex = this.staticField.lastIndexOf(46)) == -1 || lastDotIndex == this.staticField.length()) {
                throw new IllegalArgumentException("staticField must be a fully qualified class plus static field name: for example, 'example.MyExampleClass.MY_EXAMPLE_FIELD'");
            }
            String className = this.staticField.substring(0, lastDotIndex);
            String fieldName = this.staticField.substring(lastDotIndex + 1);
            this.targetClass = ClassUtils.forName(className, this.beanClassLoader);
            this.targetField = fieldName;
        } else if (this.targetField == null) {
            throw new IllegalArgumentException("targetField is required");
        }
        Class<?> targetClass = this.targetObject != null ? this.targetObject.getClass() : this.targetClass;
        this.fieldObject = targetClass.getField(this.targetField);
    }

    @Override
    @Nullable
    public Object getObject() throws IllegalAccessException {
        if (this.fieldObject == null) {
            throw new FactoryBeanNotInitializedException();
        }
        ReflectionUtils.makeAccessible(this.fieldObject);
        if (this.targetObject != null) {
            return this.fieldObject.get(this.targetObject);
        }
        return this.fieldObject.get(null);
    }

    @Override
    @Nullable
    public Class<?> getObjectType() {
        return this.fieldObject != null ? this.fieldObject.getType() : null;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}

