/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.Map;
import keycloakjar.org.springframework.beans.factory.FactoryBean;
import keycloakjar.org.springframework.beans.factory.InitializingBean;
import keycloakjar.org.springframework.beans.factory.config.YamlProcessor;
import keycloakjar.org.springframework.lang.Nullable;

public class YamlMapFactoryBean
extends YamlProcessor
implements FactoryBean<Map<String, Object>>,
InitializingBean {
    private boolean singleton = true;
    @Nullable
    private Map<String, Object> map;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.isSingleton()) {
            this.map = this.createMap();
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getObject() {
        return this.map != null ? this.map : this.createMap();
    }

    @Override
    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, Object> createMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.process((properties, map) -> this.merge(result, map));
        return result;
    }

    private void merge(Map<String, Object> output, Map<String, Object> map) {
        map.forEach((key, value) -> {
            Object existing = output.get(key);
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                if (existing instanceof Map) {
                    Map existingMap = (Map)existing;
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(existingMap);
                    this.merge(result, valueMap);
                    output.put((String)key, result);
                    return;
                }
            }
            output.put((String)key, value);
        });
    }
}

