/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.support;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import keycloakjar.org.springframework.beans.TypeConverter;
import keycloakjar.org.springframework.beans.factory.config.BeanDefinition;
import keycloakjar.org.springframework.beans.factory.config.BeanDefinitionHolder;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import keycloakjar.org.springframework.beans.factory.config.DependencyDescriptor;
import keycloakjar.org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import keycloakjar.org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import keycloakjar.org.springframework.beans.factory.support.ConstructorResolver;
import keycloakjar.org.springframework.beans.factory.support.RootBeanDefinition;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.style.ToStringCreator;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.StringUtils;

public final class RegisteredBean {
    private final ConfigurableListableBeanFactory beanFactory;
    private final Supplier<String> beanName;
    private final boolean generatedBeanName;
    private final Supplier<RootBeanDefinition> mergedBeanDefinition;
    @Nullable
    private final RegisteredBean parent;

    private RegisteredBean(ConfigurableListableBeanFactory beanFactory, Supplier<String> beanName, boolean generatedBeanName, Supplier<RootBeanDefinition> mergedBeanDefinition, @Nullable RegisteredBean parent) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.generatedBeanName = generatedBeanName;
        this.mergedBeanDefinition = mergedBeanDefinition;
        this.parent = parent;
    }

    public static RegisteredBean of(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Assert.notNull((Object)beanFactory, "'beanFactory' must not be null");
        Assert.hasLength(beanName, "'beanName' must not be empty");
        return new RegisteredBean(beanFactory, () -> beanName, false, () -> (RootBeanDefinition)beanFactory.getMergedBeanDefinition(beanName), null);
    }

    static RegisteredBean of(ConfigurableListableBeanFactory beanFactory, String beanName, RootBeanDefinition mbd) {
        return new RegisteredBean(beanFactory, () -> beanName, false, () -> mbd, null);
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, BeanDefinitionHolder innerBean) {
        Assert.notNull((Object)innerBean, "'innerBean' must not be null");
        return RegisteredBean.ofInnerBean(parent, innerBean.getBeanName(), innerBean.getBeanDefinition());
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, BeanDefinition innerBeanDefinition) {
        return RegisteredBean.ofInnerBean(parent, null, innerBeanDefinition);
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, @Nullable String innerBeanName, BeanDefinition innerBeanDefinition) {
        Assert.notNull((Object)parent, "'parent' must not be null");
        Assert.notNull((Object)innerBeanDefinition, "'innerBeanDefinition' must not be null");
        InnerBeanResolver resolver = new InnerBeanResolver(parent, innerBeanName, innerBeanDefinition);
        Supplier<String> beanName = StringUtils.hasLength(innerBeanName) ? () -> innerBeanName : resolver::resolveBeanName;
        return new RegisteredBean(parent.getBeanFactory(), beanName, innerBeanName == null, resolver::resolveMergedBeanDefinition, parent);
    }

    public String getBeanName() {
        return this.beanName.get();
    }

    public boolean isGeneratedBeanName() {
        return this.generatedBeanName;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Class<?> getBeanClass() {
        return ClassUtils.getUserClass(this.getBeanType().toClass());
    }

    public ResolvableType getBeanType() {
        return this.getMergedBeanDefinition().getResolvableType();
    }

    public RootBeanDefinition getMergedBeanDefinition() {
        return this.mergedBeanDefinition.get();
    }

    public boolean isInnerBean() {
        return this.parent != null;
    }

    @Nullable
    public RegisteredBean getParent() {
        return this.parent;
    }

    @Deprecated(since="6.1.7")
    public Executable resolveConstructorOrFactoryMethod() {
        return new ConstructorResolver((AbstractAutowireCapableBeanFactory)((Object)this.getBeanFactory())).resolveConstructorOrFactoryMethod(this.getBeanName(), this.getMergedBeanDefinition());
    }

    public InstantiationDescriptor resolveInstantiationDescriptor() {
        String factoryBeanName;
        Method method;
        Executable executable = this.resolveConstructorOrFactoryMethod();
        if (executable instanceof Method && !Modifier.isStatic((method = (Method)executable).getModifiers()) && (factoryBeanName = this.getMergedBeanDefinition().getFactoryBeanName()) != null && this.beanFactory.containsBean(factoryBeanName)) {
            return new InstantiationDescriptor(executable, this.beanFactory.getMergedBeanDefinition(factoryBeanName).getResolvableType().toClass());
        }
        return new InstantiationDescriptor(executable, executable.getDeclaringClass());
    }

    @Nullable
    public Object resolveAutowiredArgument(DependencyDescriptor descriptor, TypeConverter typeConverter, Set<String> autowiredBeanNames) {
        return new ConstructorResolver((AbstractAutowireCapableBeanFactory)((Object)this.getBeanFactory())).resolveAutowiredArgument(descriptor, descriptor.getDependencyType(), this.getBeanName(), autowiredBeanNames, typeConverter, true);
    }

    public String toString() {
        return new ToStringCreator(this).append("beanName", this.getBeanName()).append("mergedBeanDefinition", this.getMergedBeanDefinition()).toString();
    }

    private static class InnerBeanResolver {
        private final RegisteredBean parent;
        @Nullable
        private final String innerBeanName;
        private final BeanDefinition innerBeanDefinition;
        @Nullable
        private volatile String resolvedBeanName;

        InnerBeanResolver(RegisteredBean parent, @Nullable String innerBeanName, BeanDefinition innerBeanDefinition) {
            Assert.isInstanceOf(AbstractAutowireCapableBeanFactory.class, parent.getBeanFactory());
            this.parent = parent;
            this.innerBeanName = innerBeanName;
            this.innerBeanDefinition = innerBeanDefinition;
        }

        String resolveBeanName() {
            String resolvedBeanName = this.resolvedBeanName;
            if (resolvedBeanName != null) {
                return resolvedBeanName;
            }
            this.resolvedBeanName = resolvedBeanName = this.resolveInnerBean((beanName, mergedBeanDefinition) -> beanName);
            return resolvedBeanName;
        }

        RootBeanDefinition resolveMergedBeanDefinition() {
            return this.resolveInnerBean((beanName, mergedBeanDefinition) -> mergedBeanDefinition);
        }

        private <T> T resolveInnerBean(BiFunction<String, RootBeanDefinition, T> resolver) {
            BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver((AbstractAutowireCapableBeanFactory)((Object)this.parent.getBeanFactory()), this.parent.getBeanName(), this.parent.getMergedBeanDefinition());
            return beanDefinitionValueResolver.resolveInnerBean(this.innerBeanName, this.innerBeanDefinition, resolver);
        }
    }

    public record InstantiationDescriptor(Executable executable, Class<?> targetClass) {
        public InstantiationDescriptor(Executable executable) {
            this(executable, executable.getDeclaringClass());
        }
    }
}

