/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.cglib.core;

import keycloakjar.org.springframework.cglib.core.ClassGenerator;
import keycloakjar.org.springframework.cglib.core.DefaultGeneratorStrategy;
import keycloakjar.org.springframework.cglib.core.GeneratorStrategy;

public class ClassLoaderAwareGeneratorStrategy
extends DefaultGeneratorStrategy {
    private final ClassLoader classLoader;
    private final GeneratorStrategy delegate;

    public ClassLoaderAwareGeneratorStrategy(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.delegate = x$0 -> super.generate(x$0);
    }

    public ClassLoaderAwareGeneratorStrategy(ClassLoader classLoader, GeneratorStrategy delegate) {
        this.classLoader = classLoader;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generate(ClassGenerator cg) throws Exception {
        boolean overrideClassLoader;
        ClassLoader threadContextClassLoader;
        if (this.classLoader == null) {
            return this.delegate.generate(cg);
        }
        Thread currentThread = Thread.currentThread();
        try {
            threadContextClassLoader = currentThread.getContextClassLoader();
        }
        catch (Throwable ex) {
            return this.delegate.generate(cg);
        }
        boolean bl = overrideClassLoader = !this.classLoader.equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(this.classLoader);
        }
        try {
            byte[] byArray = this.delegate.generate(cg);
            return byArray;
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
    }
}

