/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import keycloakjar.org.springframework.core.KotlinDetector;
import keycloakjar.org.springframework.core.ParameterNameDiscoverer;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ObjectUtils;
import kotlin.Unit;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;

public class MethodParameter {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Executable executable;
    private final int parameterIndex;
    @Nullable
    private volatile Parameter parameter;
    private int nestingLevel;
    @Nullable
    Map<Integer, Integer> typeIndexesPerLevel;
    @Nullable
    private volatile Class<?> containingClass;
    @Nullable
    private volatile Class<?> parameterType;
    @Nullable
    private volatile Type genericParameterType;
    @Nullable
    private volatile Annotation[] parameterAnnotations;
    @Nullable
    private volatile ParameterNameDiscoverer parameterNameDiscoverer;
    @Nullable
    volatile String parameterName;
    @Nullable
    private volatile MethodParameter nestedMethodParameter;

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        Assert.notNull((Object)method, "Method must not be null");
        this.executable = method;
        this.parameterIndex = MethodParameter.validateIndex(method, parameterIndex);
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(Constructor<?> constructor, int parameterIndex) {
        this(constructor, parameterIndex, 1);
    }

    public MethodParameter(Constructor<?> constructor, int parameterIndex, int nestingLevel) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.executable = constructor;
        this.parameterIndex = MethodParameter.validateIndex(constructor, parameterIndex);
        this.nestingLevel = nestingLevel;
    }

    MethodParameter(Executable executable, int parameterIndex, @Nullable Class<?> containingClass) {
        Assert.notNull((Object)executable, "Executable must not be null");
        this.executable = executable;
        this.parameterIndex = MethodParameter.validateIndex(executable, parameterIndex);
        this.nestingLevel = 1;
        this.containingClass = containingClass;
    }

    public MethodParameter(MethodParameter original) {
        Assert.notNull((Object)original, "Original must not be null");
        this.executable = original.executable;
        this.parameterIndex = original.parameterIndex;
        this.parameter = original.parameter;
        this.nestingLevel = original.nestingLevel;
        this.typeIndexesPerLevel = original.typeIndexesPerLevel;
        this.containingClass = original.containingClass;
        this.parameterType = original.parameterType;
        this.genericParameterType = original.genericParameterType;
        this.parameterAnnotations = original.parameterAnnotations;
        this.parameterNameDiscoverer = original.parameterNameDiscoverer;
        this.parameterName = original.parameterName;
    }

    @Nullable
    public Method getMethod() {
        Method method;
        Executable executable = this.executable;
        return executable instanceof Method ? (method = (Method)executable) : null;
    }

    @Nullable
    public Constructor<?> getConstructor() {
        Constructor constructor;
        Executable executable = this.executable;
        return executable instanceof Constructor ? (constructor = (Constructor)executable) : null;
    }

    public Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    public Member getMember() {
        return this.executable;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Parameter getParameter() {
        if (this.parameterIndex < 0) {
            throw new IllegalStateException("Cannot retrieve Parameter descriptor for method return type");
        }
        Parameter parameter = this.parameter;
        if (parameter == null) {
            this.parameter = parameter = this.getExecutable().getParameters()[this.parameterIndex];
        }
        return parameter;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Deprecated
    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    @Deprecated
    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(this.nestingLevel);
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public MethodParameter withTypeIndex(int typeIndex) {
        return this.nested(this.nestingLevel, typeIndex);
    }

    @Deprecated
    public void setTypeIndexForCurrentLevel(int typeIndex) {
        this.getTypeIndexesPerLevel().put(this.nestingLevel, typeIndex);
    }

    @Nullable
    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    @Nullable
    public Integer getTypeIndexForLevel(int nestingLevel) {
        return this.getTypeIndexesPerLevel().get(nestingLevel);
    }

    private Map<Integer, Integer> getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap<Integer, Integer>(4);
        }
        return this.typeIndexesPerLevel;
    }

    public MethodParameter nested() {
        return this.nested(null);
    }

    public MethodParameter nested(@Nullable Integer typeIndex) {
        MethodParameter nestedParam = this.nestedMethodParameter;
        if (nestedParam != null && typeIndex == null) {
            return nestedParam;
        }
        nestedParam = this.nested(this.nestingLevel + 1, typeIndex);
        if (typeIndex == null) {
            this.nestedMethodParameter = nestedParam;
        }
        return nestedParam;
    }

    private MethodParameter nested(int nestingLevel, @Nullable Integer typeIndex) {
        MethodParameter copy = this.clone();
        copy.nestingLevel = nestingLevel;
        if (this.typeIndexesPerLevel != null) {
            copy.typeIndexesPerLevel = new HashMap<Integer, Integer>(this.typeIndexesPerLevel);
        }
        if (typeIndex != null) {
            copy.getTypeIndexesPerLevel().put(copy.nestingLevel, typeIndex);
        }
        copy.parameterType = null;
        copy.genericParameterType = null;
        return copy;
    }

    public boolean isOptional() {
        return this.getParameterType() == Optional.class || this.hasNullableAnnotation() || KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass()) && KotlinDelegate.isOptional(this);
    }

    private boolean hasNullableAnnotation() {
        for (Annotation ann : this.getParameterAnnotations()) {
            if (!"Nullable".equals(ann.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public MethodParameter nestedIfOptional() {
        return this.getParameterType() == Optional.class ? this.nested() : this;
    }

    public MethodParameter withContainingClass(@Nullable Class<?> containingClass) {
        MethodParameter result = this.clone();
        result.containingClass = containingClass;
        result.parameterType = null;
        return result;
    }

    @Deprecated
    void setContainingClass(Class<?> containingClass) {
        this.containingClass = containingClass;
        this.parameterType = null;
    }

    public Class<?> getContainingClass() {
        Class<?> containingClass = this.containingClass;
        return containingClass != null ? containingClass : this.getDeclaringClass();
    }

    @Deprecated
    void setParameterType(@Nullable Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public Class<?> getParameterType() {
        Class<?> paramType = this.parameterType;
        if (paramType != null) {
            return paramType;
        }
        if (this.getContainingClass() != this.getDeclaringClass()) {
            paramType = ResolvableType.forMethodParameter(this, null, 1).resolve();
        }
        if (paramType == null) {
            paramType = this.computeParameterType();
        }
        this.parameterType = paramType;
        return paramType;
    }

    public Type getGenericParameterType() {
        Class<Void> paramType = this.genericParameterType;
        if (paramType == null) {
            if (this.parameterIndex < 0) {
                Method method = this.getMethod();
                paramType = method != null ? (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass()) ? KotlinDelegate.getGenericReturnType(method) : method.getGenericReturnType()) : Void.TYPE;
            } else {
                Type[] genericParameterTypes = this.executable.getGenericParameterTypes();
                int index = this.parameterIndex;
                if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && genericParameterTypes.length == this.executable.getParameterCount() - 1) {
                    index = this.parameterIndex - 1;
                }
                paramType = index >= 0 && index < genericParameterTypes.length ? genericParameterTypes[index] : this.computeParameterType();
            }
            this.genericParameterType = paramType;
        }
        return paramType;
    }

    private Class<?> computeParameterType() {
        if (this.parameterIndex < 0) {
            Method method = this.getMethod();
            if (method == null) {
                return Void.TYPE;
            }
            if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass())) {
                return KotlinDelegate.getReturnType(method);
            }
            return method.getReturnType();
        }
        return this.executable.getParameterTypes()[this.parameterIndex];
    }

    public Class<?> getNestedParameterType() {
        if (this.nestingLevel > 1) {
            Type arg;
            ParameterizedType parameterizedType;
            Type type = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type instanceof ParameterizedType)) continue;
                parameterizedType = (ParameterizedType)type;
                Type[] args = parameterizedType.getActualTypeArguments();
                Integer index = this.getTypeIndexForLevel(i);
                type = args[index != null ? index : args.length - 1];
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz;
            }
            if (type instanceof ParameterizedType && (arg = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
                Class clazz = (Class)arg;
                return clazz;
            }
            return Object.class;
        }
        return this.getParameterType();
    }

    public Type getNestedGenericParameterType() {
        if (this.nestingLevel > 1) {
            Type type = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] args = parameterizedType.getActualTypeArguments();
                Integer index = this.getTypeIndexForLevel(i);
                type = args[index != null ? index : args.length - 1];
            }
            return type;
        }
        return this.getGenericParameterType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.adaptAnnotationArray(this.getAnnotatedElement().getAnnotations());
    }

    @Nullable
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        A annotation = this.getAnnotatedElement().getAnnotation(annotationType);
        return annotation != null ? (A)this.adaptAnnotation(annotation) : null;
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
        return this.getAnnotatedElement().isAnnotationPresent(annotationType);
    }

    public Annotation[] getParameterAnnotations() {
        Annotation[] paramAnns = this.parameterAnnotations;
        if (paramAnns == null) {
            Annotation[][] annotationArray = this.executable.getParameterAnnotations();
            int index = this.parameterIndex;
            if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && annotationArray.length == this.executable.getParameterCount() - 1) {
                index = this.parameterIndex - 1;
            }
            paramAnns = index >= 0 && index < annotationArray.length && annotationArray[index].length > 0 ? this.adaptAnnotationArray(annotationArray[index]) : EMPTY_ANNOTATION_ARRAY;
            this.parameterAnnotations = paramAnns;
        }
        return paramAnns;
    }

    public boolean hasParameterAnnotations() {
        return this.getParameterAnnotations().length != 0;
    }

    @Nullable
    public <A extends Annotation> A getParameterAnnotation(Class<A> annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getParameterAnnotations()) {
            if (!annotationType.isInstance(ann)) continue;
            return (A)ann;
        }
        return null;
    }

    public <A extends Annotation> boolean hasParameterAnnotation(Class<A> annotationType) {
        return this.getParameterAnnotation(annotationType) != null;
    }

    public void initParameterNameDiscovery(@Nullable ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    @Nullable
    public String getParameterName() {
        if (this.parameterIndex < 0) {
            return null;
        }
        ParameterNameDiscoverer discoverer = this.parameterNameDiscoverer;
        if (discoverer != null) {
            String[] parameterNames = null;
            Executable executable = this.executable;
            if (executable instanceof Method) {
                Method method = (Method)executable;
                parameterNames = discoverer.getParameterNames(method);
            } else {
                executable = this.executable;
                if (executable instanceof Constructor) {
                    Constructor constructor = (Constructor)executable;
                    parameterNames = discoverer.getParameterNames(constructor);
                }
            }
            if (parameterNames != null && this.parameterIndex < parameterNames.length) {
                this.parameterName = parameterNames[this.parameterIndex];
            }
            this.parameterNameDiscoverer = null;
        }
        return this.parameterName;
    }

    protected <A extends Annotation> A adaptAnnotation(A annotation) {
        return annotation;
    }

    protected Annotation[] adaptAnnotationArray(Annotation[] annotations) {
        return annotations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MethodParameter)) return false;
        MethodParameter that = (MethodParameter)other;
        if (this.getContainingClass() != that.getContainingClass()) return false;
        if (!ObjectUtils.nullSafeEquals(this.typeIndexesPerLevel, that.typeIndexesPerLevel)) return false;
        if (this.nestingLevel != that.nestingLevel) return false;
        if (this.parameterIndex != that.parameterIndex) return false;
        if (!this.executable.equals(that.executable)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.executable.hashCode() + this.parameterIndex;
    }

    public String toString() {
        Method method = this.getMethod();
        return (String)(method != null ? "method '" + method.getName() + "'" : "constructor") + " parameter " + this.parameterIndex;
    }

    public MethodParameter clone() {
        return new MethodParameter(this);
    }

    @Deprecated
    public static MethodParameter forMethodOrConstructor(Object methodOrConstructor, int parameterIndex) {
        if (!(methodOrConstructor instanceof Executable)) {
            throw new IllegalArgumentException("Given object [" + String.valueOf(methodOrConstructor) + "] is neither a Method nor a Constructor");
        }
        Executable executable = (Executable)methodOrConstructor;
        return MethodParameter.forExecutable(executable, parameterIndex);
    }

    public static MethodParameter forExecutable(Executable executable, int parameterIndex) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return new MethodParameter(method, parameterIndex);
        }
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            return new MethodParameter(constructor, parameterIndex);
        }
        throw new IllegalArgumentException("Not a Method/Constructor: " + String.valueOf(executable));
    }

    public static MethodParameter forParameter(Parameter parameter) {
        return MethodParameter.forExecutable(parameter.getDeclaringExecutable(), MethodParameter.findParameterIndex(parameter));
    }

    protected static int findParameterIndex(Parameter parameter) {
        int i;
        Executable executable = parameter.getDeclaringExecutable();
        Parameter[] allParams = executable.getParameters();
        for (i = 0; i < allParams.length; ++i) {
            if (parameter != allParams[i]) continue;
            return i;
        }
        for (i = 0; i < allParams.length; ++i) {
            if (!parameter.equals(allParams[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Given parameter [" + String.valueOf(parameter) + "] does not match any parameter in the declaring executable");
    }

    private static int validateIndex(Executable executable, int parameterIndex) {
        int count = executable.getParameterCount();
        Assert.isTrue(parameterIndex >= -1 && parameterIndex < count, () -> "Parameter index needs to be between -1 and " + (count - 1));
        return parameterIndex;
    }

    public static MethodParameter forFieldAwareConstructor(Constructor<?> ctor, int parameterIndex, String fieldName) {
        return new FieldAwareConstructorParameter(ctor, parameterIndex, fieldName);
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean isOptional(MethodParameter param) {
            Predicate<KParameter> predicate;
            KFunction function;
            Method method = param.getMethod();
            int index = param.getParameterIndex();
            if (method != null && index == -1) {
                KFunction function2 = ReflectJvmMapping.getKotlinFunction((Method)method);
                return function2 != null && function2.getReturnType().isMarkedNullable();
            }
            if (method != null) {
                if (param.getParameterType().getName().equals("kotlin.coroutines.Continuation")) {
                    return true;
                }
                function = ReflectJvmMapping.getKotlinFunction((Method)method);
                predicate = p -> KParameter.Kind.VALUE.equals((Object)p.getKind());
            } else {
                Constructor<?> ctor = param.getConstructor();
                Assert.state(ctor != null, "Neither method nor constructor found");
                function = ReflectJvmMapping.getKotlinFunction(ctor);
                predicate = p -> KParameter.Kind.VALUE.equals((Object)p.getKind()) || KParameter.Kind.INSTANCE.equals((Object)p.getKind());
            }
            if (function != null) {
                int i = 0;
                for (KParameter kParameter : function.getParameters()) {
                    if (!predicate.test(kParameter) || index != i++) continue;
                    return kParameter.getType().isMarkedNullable() || kParameter.isOptional();
                }
            }
            return false;
        }

        private static Type getGenericReturnType(Method method) {
            try {
                KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (function != null && function.isSuspend()) {
                    return ReflectJvmMapping.getJavaType((KType)function.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getGenericReturnType();
        }

        private static Class<?> getReturnType(Method method) {
            try {
                KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (function != null && function.isSuspend()) {
                    Class<Void> paramType = ReflectJvmMapping.getJavaType((KType)function.getReturnType());
                    if (paramType == Unit.class) {
                        paramType = Void.TYPE;
                    }
                    return ResolvableType.forType(paramType).resolve(method.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getReturnType();
        }
    }

    private static class FieldAwareConstructorParameter
    extends MethodParameter {
        @Nullable
        private volatile Annotation[] combinedAnnotations;

        public FieldAwareConstructorParameter(Constructor<?> constructor, int parameterIndex, String fieldName) {
            super(constructor, parameterIndex);
            this.parameterName = fieldName;
        }

        @Override
        public Annotation[] getParameterAnnotations() {
            String parameterName = this.parameterName;
            Assert.state(parameterName != null, "Parameter name not initialized");
            Annotation[] anns = this.combinedAnnotations;
            if (anns == null) {
                anns = super.getParameterAnnotations();
                try {
                    Field field = this.getDeclaringClass().getDeclaredField(parameterName);
                    Annotation[] fieldAnns = field.getAnnotations();
                    if (fieldAnns.length > 0) {
                        ArrayList<Annotation> merged = new ArrayList<Annotation>(anns.length + fieldAnns.length);
                        merged.addAll(Arrays.asList(anns));
                        for (Annotation fieldAnn : fieldAnns) {
                            boolean existingType = false;
                            for (Annotation ann : anns) {
                                if (ann.annotationType() != fieldAnn.annotationType()) continue;
                                existingType = true;
                                break;
                            }
                            if (existingType) continue;
                            merged.add(fieldAnn);
                        }
                        anns = merged.toArray(EMPTY_ANNOTATION_ARRAY);
                    }
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
                this.combinedAnnotations = anns;
            }
            return anns;
        }
    }
}

