/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.annotation;

import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.core.annotation.MergedAnnotation;
import keycloakjar.org.springframework.lang.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum IntrospectionFailureLogger {
    DEBUG{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isDebugEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().debug(message);
        }
    }
    ,
    INFO{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isInfoEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().info(message);
        }
    };

    @Nullable
    private static Log logger;

    void log(String message, @Nullable Object source, Exception ex) {
        String on = source != null ? " on " + String.valueOf(source) : "";
        this.log(message + on + ": " + String.valueOf(ex));
    }

    abstract boolean isEnabled();

    abstract void log(String var1);

    private static Log getLogger() {
        Log logger = IntrospectionFailureLogger.logger;
        if (logger == null) {
            IntrospectionFailureLogger.logger = logger = LogFactory.getLog(MergedAnnotation.class);
        }
        return logger;
    }
}

