/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.AbstractDataBufferDecoder;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.io.buffer.NettyDataBuffer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MimeTypeUtils;

public class NettyByteBufDecoder
extends AbstractDataBufferDecoder<ByteBuf> {
    public NettyByteBufDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return ByteBuf.class.isAssignableFrom(elementType.toClass()) && super.canDecode(elementType, mimeType);
    }

    @Override
    public ByteBuf decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Read " + dataBuffer.readableByteCount() + " bytes");
        }
        if (dataBuffer instanceof NettyDataBuffer) {
            NettyDataBuffer nettyDataBuffer = (NettyDataBuffer)dataBuffer;
            return nettyDataBuffer.getNativeBuffer();
        }
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        DataBufferUtils.release(dataBuffer);
        return byteBuf;
    }
}

