/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.core.convert.TypeDescriptor;
import keycloakjar.org.springframework.core.convert.converter.ConditionalGenericConverter;
import keycloakjar.org.springframework.core.convert.converter.GenericConverter;
import keycloakjar.org.springframework.core.convert.support.CollectionToStringConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ObjectUtils;

final class ArrayToStringConverter
implements ConditionalGenericConverter {
    private final CollectionToStringConverter helperConverter;

    public ArrayToStringConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToStringConverter(conversionService);
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.matches(sourceType, targetType);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.convert(Arrays.asList(ObjectUtils.toObjectArray(source)), sourceType, targetType);
    }
}

