/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.io.buffer;

import java.nio.ByteBuffer;
import java.util.List;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.JettyDataBuffer;
import org.eclipse.jetty.io.Content;

public class JettyDataBufferFactory
implements DataBufferFactory {
    private final DefaultDataBufferFactory delegate;

    public JettyDataBufferFactory() {
        this(false);
    }

    public JettyDataBufferFactory(boolean preferDirect) {
        this(preferDirect, 256);
    }

    public JettyDataBufferFactory(boolean preferDirect, int defaultInitialCapacity) {
        this.delegate = new DefaultDataBufferFactory(preferDirect, defaultInitialCapacity);
    }

    @Override
    @Deprecated
    public JettyDataBuffer allocateBuffer() {
        DefaultDataBuffer delegate = this.delegate.allocateBuffer();
        return new JettyDataBuffer(this, delegate);
    }

    @Override
    public JettyDataBuffer allocateBuffer(int initialCapacity) {
        DefaultDataBuffer delegate = this.delegate.allocateBuffer(initialCapacity);
        return new JettyDataBuffer(this, delegate);
    }

    @Override
    public JettyDataBuffer wrap(ByteBuffer byteBuffer) {
        DefaultDataBuffer delegate = this.delegate.wrap(byteBuffer);
        return new JettyDataBuffer(this, delegate);
    }

    @Override
    public JettyDataBuffer wrap(byte[] bytes) {
        DefaultDataBuffer delegate = this.delegate.wrap(bytes);
        return new JettyDataBuffer(this, delegate);
    }

    public JettyDataBuffer wrap(Content.Chunk chunk) {
        ByteBuffer byteBuffer = chunk.getByteBuffer();
        DefaultDataBuffer delegate = this.delegate.wrap(byteBuffer);
        return new JettyDataBuffer(this, delegate, chunk);
    }

    @Override
    public JettyDataBuffer join(List<? extends DataBuffer> dataBuffers) {
        DataBuffer delegate = this.delegate.join((List)dataBuffers);
        return new JettyDataBuffer(this, (DefaultDataBuffer)delegate);
    }

    @Override
    public boolean isDirect() {
        return this.delegate.isDirect();
    }
}

