/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.task;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class TaskRejectedException
extends RejectedExecutionException {
    public TaskRejectedException(String msg) {
        super(msg);
    }

    public TaskRejectedException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public TaskRejectedException(Executor executor, Object task, RejectedExecutionException cause) {
        super(TaskRejectedException.executorDescription(executor) + " did not accept task: " + String.valueOf(task), cause);
    }

    private static String executorDescription(Executor executor) {
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            try {
                return "ExecutorService in " + (executorService.isShutdown() ? "shutdown" : "active") + " state";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return executor.toString();
    }
}

