/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http;

import java.io.Serializable;
import keycloakjar.org.springframework.http.DefaultHttpStatusCode;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HttpStatusCode
extends Serializable {
    public int value();

    public boolean is1xxInformational();

    public boolean is2xxSuccessful();

    public boolean is3xxRedirection();

    public boolean is4xxClientError();

    public boolean is5xxServerError();

    public boolean isError();

    default public boolean isSameCodeAs(HttpStatusCode other) {
        return this.value() == other.value();
    }

    public static HttpStatusCode valueOf(int code) {
        Assert.isTrue(code >= 100 && code <= 999, () -> "Status code '" + code + "' should be a three-digit positive integer");
        HttpStatus status = HttpStatus.resolve(code);
        if (status != null) {
            return status;
        }
        return new DefaultHttpStatusCode(code);
    }
}

