/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import keycloakjar.org.apache.hc.client5.http.cookie.Cookie;
import keycloakjar.org.apache.hc.client5.http.cookie.CookieOrigin;
import keycloakjar.org.apache.hc.client5.http.cookie.CookieSpec;
import keycloakjar.org.apache.hc.client5.http.cookie.MalformedCookieException;
import keycloakjar.org.apache.hc.client5.http.protocol.HttpClientContext;
import keycloakjar.org.apache.hc.core5.http.Header;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.Message;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.client.reactive.AbstractClientHttpResponse;
import keycloakjar.org.springframework.http.support.HttpComponentsHeadersAdapter;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class HttpComponentsClientHttpResponse
extends AbstractClientHttpResponse {
    public HttpComponentsClientHttpResponse(DataBufferFactory dataBufferFactory, Message<HttpResponse, Publisher<ByteBuffer>> message, HttpClientContext context) {
        super(HttpStatusCode.valueOf(message.getHead().getCode()), HttpHeaders.readOnlyHttpHeaders(new HttpComponentsHeadersAdapter(message.getHead())), HttpComponentsClientHttpResponse.adaptCookies(message.getHead(), context), (Flux<DataBuffer>)Flux.from(message.getBody()).map(dataBufferFactory::wrap));
    }

    private static MultiValueMap<String, ResponseCookie> adaptCookies(HttpResponse response, HttpClientContext context) {
        LinkedMultiValueMap<String, ResponseCookie> result = new LinkedMultiValueMap<String, ResponseCookie>();
        CookieSpec cookieSpec = context.getCookieSpec();
        if (cookieSpec == null) {
            return result;
        }
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Iterator<Header> itr = response.headerIterator("Set-Cookie");
        while (itr.hasNext()) {
            Header header = itr.next();
            try {
                List<Cookie> cookies = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        result.add(cookie.getName(), ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(HttpComponentsClientHttpResponse.getMaxAgeSeconds(cookie)).secure(cookie.isSecure()).httpOnly(cookie.containsAttribute("httponly")).partitioned(cookie.containsAttribute("partitioned")).sameSite(cookie.getAttribute("samesite")).build());
                    }
                    catch (MalformedCookieException malformedCookieException) {}
                }
            }
            catch (MalformedCookieException malformedCookieException) {
            }
        }
        return result;
    }

    private static long getMaxAgeSeconds(Cookie cookie) {
        String expiresAttribute = cookie.getAttribute("expires");
        String maxAgeAttribute = cookie.getAttribute("max-age");
        if (maxAgeAttribute != null) {
            return Long.parseLong(maxAgeAttribute);
        }
        if (expiresAttribute != null) {
            try {
                ZonedDateTime expiresDate = ZonedDateTime.parse(expiresAttribute, DateTimeFormatter.RFC_1123_DATE_TIME);
                return Duration.between(ZonedDateTime.now(expiresDate.getZone()), expiresDate).toSeconds();
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

