/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import keycloakjar.org.springframework.http.ContentDisposition;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.codec.multipart.DefaultPartEvents;
import keycloakjar.org.springframework.http.codec.multipart.PartEvent;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface FormPartEvent
extends PartEvent {
    public String value();

    public static Mono<FormPartEvent> create(String name, String value) {
        return FormPartEvent.create(name, value, null);
    }

    public static Mono<FormPartEvent> create(String name, String value, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength(name, "Name must not be empty");
        Assert.notNull((Object)value, "Value must not be null");
        return Mono.fromCallable(() -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
            headers.setContentDisposition(ContentDisposition.formData().name(name).build());
            if (headersConsumer != null) {
                headersConsumer.accept(headers);
            }
            return DefaultPartEvents.form(headers, value);
        });
    }
}

