/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import keycloakjar.org.springframework.core.codec.CodecException;

final class JaxbContextContainer {
    private final ConcurrentMap<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap(64);

    JaxbContextContainer() {
    }

    public Marshaller createMarshaller(Class<?> clazz) throws CodecException, JAXBException {
        JAXBContext jaxbContext = this.getJaxbContext(clazz);
        return jaxbContext.createMarshaller();
    }

    public Unmarshaller createUnmarshaller(Class<?> clazz) throws CodecException, JAXBException {
        JAXBContext jaxbContext = this.getJaxbContext(clazz);
        return jaxbContext.createUnmarshaller();
    }

    private JAXBContext getJaxbContext(Class<?> clazz) throws CodecException {
        return this.jaxbContexts.computeIfAbsent(clazz, key -> {
            try {
                return this.createJaxbContext(clazz);
            }
            catch (JAXBException ex) {
                throw new CodecException("Could not create JAXBContext for class [" + String.valueOf(clazz) + "]: " + ex.getMessage(), ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext createJaxbContext(Class<?> clazz) throws JAXBException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            return jAXBContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

