/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.converter.AbstractKotlinSerializationHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageNotReadableException;
import keycloakjar.org.springframework.http.converter.HttpMessageNotWritableException;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StreamUtils;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.StringFormat;

public abstract class KotlinSerializationStringHttpMessageConverter<T extends StringFormat>
extends AbstractKotlinSerializationHttpMessageConverter<T> {
    protected KotlinSerializationStringHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(format, supportedMediaTypes);
    }

    @Override
    protected Object readInternal(KSerializer<Object> serializer, T format, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Charset charset = KotlinSerializationStringHttpMessageConverter.charset(inputMessage.getHeaders().getContentType());
        String s2 = StreamUtils.copyToString(inputMessage.getBody(), charset);
        try {
            return format.decodeFromString(serializer, s2);
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotReadableException("Could not read " + String.valueOf(format) + ": " + ex.getMessage(), ex, inputMessage);
        }
    }

    @Override
    protected void writeInternal(Object object, KSerializer<Object> serializer, T format, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            String s2 = format.encodeToString(serializer, object);
            Charset charset = KotlinSerializationStringHttpMessageConverter.charset(outputMessage.getHeaders().getContentType());
            outputMessage.getBody().write(s2.getBytes(charset));
            outputMessage.getBody().flush();
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotWritableException("Could not write " + String.valueOf(format) + ": " + ex.getMessage(), ex);
        }
    }

    private static Charset charset(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }
}

