/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBufferFactory;
import keycloakjar.org.springframework.core.log.LogDelegateFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;

public abstract class AbstractListenerReadPublisher<T>
implements Publisher<T> {
    protected static Log rsReadLogger = LogDelegateFactory.getHiddenLog(AbstractListenerReadPublisher.class);
    static final DataBuffer EMPTY_BUFFER = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private volatile long demand;
    private static final AtomicLongFieldUpdater<AbstractListenerReadPublisher> DEMAND_FIELD_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractListenerReadPublisher.class, "demand");
    @Nullable
    private volatile Subscriber<? super T> subscriber;
    private volatile boolean completionPending;
    @Nullable
    private volatile Throwable errorPending;
    private final String logPrefix;

    public AbstractListenerReadPublisher() {
        this("");
    }

    public AbstractListenerReadPublisher(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        this.state.get().subscribe(this, subscriber);
    }

    public final void onDataAvailable() {
        rsReadLogger.trace(this.getLogPrefix() + "onDataAvailable");
        this.state.get().onDataAvailable(this);
    }

    public void onAllDataRead() {
        State state = this.state.get();
        if (rsReadLogger.isTraceEnabled()) {
            rsReadLogger.trace(this.getLogPrefix() + "onAllDataRead [" + String.valueOf((Object)state) + "]");
        }
        state.onAllDataRead(this);
    }

    public final void onError(Throwable ex) {
        State state = this.state.get();
        if (rsReadLogger.isTraceEnabled()) {
            rsReadLogger.trace(this.getLogPrefix() + "onError: " + String.valueOf(ex) + " [" + String.valueOf((Object)state) + "]");
        }
        state.onError(this, ex);
    }

    protected abstract void checkOnDataAvailable();

    @Nullable
    protected abstract T read() throws IOException;

    protected abstract void readingPaused();

    protected abstract void discardData();

    private boolean readAndPublish() throws IOException {
        long r;
        while ((r = this.demand) > 0L && this.state.get() != State.COMPLETED) {
            T data = this.read();
            if (data == EMPTY_BUFFER) {
                if (!rsReadLogger.isTraceEnabled()) continue;
                rsReadLogger.trace(this.getLogPrefix() + "0 bytes read, trying again");
                continue;
            }
            if (data != null) {
                Subscriber<? super T> subscriber;
                if (r != Long.MAX_VALUE) {
                    DEMAND_FIELD_UPDATER.addAndGet(this, -1L);
                }
                Assert.state((subscriber = this.subscriber) != null, "No subscriber");
                if (rsReadLogger.isTraceEnabled()) {
                    rsReadLogger.trace(this.getLogPrefix() + "Publishing " + data.getClass().getSimpleName());
                }
                subscriber.onNext(data);
                continue;
            }
            if (rsReadLogger.isTraceEnabled()) {
                rsReadLogger.trace(this.getLogPrefix() + "No more to read");
            }
            return true;
        }
        return false;
    }

    private boolean changeState(State oldState, State newState) {
        boolean result = this.state.compareAndSet(oldState, newState);
        if (result && rsReadLogger.isTraceEnabled()) {
            rsReadLogger.trace(this.getLogPrefix() + String.valueOf((Object)oldState) + " -> " + String.valueOf((Object)newState));
        }
        return result;
    }

    private void changeToDemandState(State oldState) {
        if (this.changeState(oldState, State.DEMAND) && oldState != State.READING) {
            this.checkOnDataAvailable();
        }
    }

    private boolean handlePendingCompletionOrError() {
        State state = this.state.get();
        if (state == State.DEMAND || state == State.NO_DEMAND) {
            if (this.completionPending) {
                rsReadLogger.trace(this.getLogPrefix() + "Processing pending completion");
                this.state.get().onAllDataRead(this);
                return true;
            }
            Throwable ex = this.errorPending;
            if (ex != null) {
                if (rsReadLogger.isTraceEnabled()) {
                    rsReadLogger.trace(this.getLogPrefix() + "Processing pending completion with error: " + String.valueOf(ex));
                }
                this.state.get().onError(this, ex);
                return true;
            }
        }
        return false;
    }

    private Subscription createSubscription() {
        return new ReadSubscription();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        UNSUBSCRIBED{

            @Override
            <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
                Assert.notNull(publisher, "Publisher must not be null");
                Assert.notNull(subscriber, "Subscriber must not be null");
                if (!publisher.changeState(this, SUBSCRIBING)) {
                    throw new IllegalStateException("Failed to transition to SUBSCRIBING, subscriber: " + String.valueOf(subscriber));
                }
                Subscription subscription = publisher.createSubscription();
                publisher.subscriber = subscriber;
                subscriber.onSubscribe(subscription);
                publisher.changeState(SUBSCRIBING, NO_DEMAND);
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
                publisher.completionPending = true;
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable ex) {
                publisher.errorPending = ex;
                publisher.handlePendingCompletionOrError();
            }
        }
        ,
        SUBSCRIBING{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(DEMAND_FIELD_UPDATER, publisher, (long)n);
                    publisher.changeToDemandState(this);
                }
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
                publisher.completionPending = true;
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable ex) {
                publisher.errorPending = ex;
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
                publisher.completionPending = true;
                publisher.handlePendingCompletionOrError();
            }
        }
        ,
        NO_DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(DEMAND_FIELD_UPDATER, publisher, (long)n);
                    publisher.changeToDemandState(this);
                }
            }
        }
        ,
        DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(DEMAND_FIELD_UPDATER, publisher, (long)n);
                    publisher.changeToDemandState(NO_DEMAND);
                }
            }

            @Override
            <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
                if (publisher.changeState(this, READING)) {
                    try {
                        boolean demandAvailable = publisher.readAndPublish();
                        if (demandAvailable) {
                            publisher.changeToDemandState(READING);
                            publisher.handlePendingCompletionOrError();
                        } else {
                            long r;
                            publisher.readingPaused();
                            if (publisher.changeState(READING, NO_DEMAND) && !publisher.handlePendingCompletionOrError() && (r = publisher.demand) > 0L) {
                                publisher.changeToDemandState(NO_DEMAND);
                            }
                        }
                    }
                    catch (IOException ex) {
                        publisher.onError(ex);
                    }
                }
            }
        }
        ,
        READING{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(DEMAND_FIELD_UPDATER, publisher, (long)n);
                    publisher.changeToDemandState(NO_DEMAND);
                }
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
                publisher.completionPending = true;
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable ex) {
                publisher.errorPending = ex;
                publisher.handlePendingCompletionOrError();
            }

            @Override
            <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
                publisher.discardData();
                publisher.completionPending = true;
                publisher.handlePendingCompletionOrError();
            }
        }
        ,
        COMPLETED{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            }

            @Override
            <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t2) {
            }
        };


        <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            if (publisher.changeState(this, COMPLETED)) {
                publisher.discardData();
            } else {
                publisher.state.get().cancel(publisher);
            }
        }

        <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
        }

        <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            if (publisher.changeState(this, COMPLETED)) {
                Subscriber s2 = publisher.subscriber;
                if (s2 != null) {
                    s2.onComplete();
                }
            } else {
                publisher.state.get().onAllDataRead(publisher);
            }
        }

        <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t2) {
            if (publisher.changeState(this, COMPLETED)) {
                publisher.discardData();
                Subscriber s2 = publisher.subscriber;
                if (s2 != null) {
                    s2.onError(t2);
                }
            } else {
                publisher.state.get().onError(publisher, t2);
            }
        }
    }

    private final class ReadSubscription
    implements Subscription {
        private ReadSubscription() {
        }

        public void request(long n) {
            if (rsReadLogger.isTraceEnabled()) {
                rsReadLogger.trace(AbstractListenerReadPublisher.this.getLogPrefix() + "request " + String.valueOf(n != Long.MAX_VALUE ? Long.valueOf(n) : "Long.MAX_VALUE"));
            }
            AbstractListenerReadPublisher.this.state.get().request(AbstractListenerReadPublisher.this, n);
        }

        public void cancel() {
            State state = AbstractListenerReadPublisher.this.state.get();
            if (rsReadLogger.isTraceEnabled()) {
                rsReadLogger.trace(AbstractListenerReadPublisher.this.getLogPrefix() + "cancel [" + String.valueOf((Object)state) + "]");
            }
            state.cancel(AbstractListenerReadPublisher.this);
        }
    }
}

