/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Flow;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.JettyDataBufferFactory;
import keycloakjar.org.springframework.http.HttpCookie;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.server.reactive.AbstractServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.DefaultSslInfo;
import keycloakjar.org.springframework.http.server.reactive.SslInfo;
import keycloakjar.org.springframework.http.support.JettyHeadersAdapter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class JettyCoreServerHttpRequest
extends AbstractServerHttpRequest {
    private final JettyDataBufferFactory dataBufferFactory;
    private final Request request;

    public JettyCoreServerHttpRequest(Request request, JettyDataBufferFactory dataBufferFactory) {
        super(HttpMethod.valueOf(request.getMethod()), request.getHttpURI().toURI(), request.getContext().getContextPath(), new HttpHeaders(new JettyHeadersAdapter(request.getHeaders())));
        this.dataBufferFactory = dataBufferFactory;
        this.request = request;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        List httpCookies = Request.getCookies((Request)this.request);
        if (httpCookies.isEmpty()) {
            return CollectionUtils.toMultiValueMap(Collections.emptyMap());
        }
        LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap<String, HttpCookie>();
        for (org.eclipse.jetty.http.HttpCookie c : httpCookies) {
            cookies.add(c.getName(), new HttpCookie(c.getName(), c.getValue()));
        }
        return cookies;
    }

    @Override
    @Nullable
    public SslInfo initSslInfo() {
        Object object;
        if (this.request.getConnectionMetaData().isSecure() && (object = this.request.getAttribute("org.eclipse.jetty.io.Endpoint.SslSessionData")) instanceof EndPoint.SslSessionData) {
            EndPoint.SslSessionData sessionData = (EndPoint.SslSessionData)object;
            return new DefaultSslInfo(sessionData.sslSessionId(), sessionData.peerCertificates());
        }
        return null;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    protected String initId() {
        return this.request.getId();
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress inet;
        SocketAddress localAddress = this.request.getConnectionMetaData().getLocalSocketAddress();
        return localAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)localAddress) : null;
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress inet;
        SocketAddress remoteAddress = this.request.getConnectionMetaData().getRemoteSocketAddress();
        return remoteAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)remoteAddress) : null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)FlowAdapters.toPublisher((Flow.Publisher)Content.Source.asPublisher((Content.Source)this.request))).map(this.dataBufferFactory::wrap);
    }
}

