/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.server.reactive.HttpHandler;
import keycloakjar.org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import keycloakjar.org.springframework.http.server.reactive.ServletServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.eclipse.jetty.ee10.servlet.HttpOutput;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context, ServletServerHttpRequest request) throws IOException {
        return new Jetty12ServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class Jetty12ServerHttpResponse
    extends ServletServerHttpResponse {
        Jetty12ServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(response, asyncContext, bufferFactory, bufferSize, request);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream output = this.getOutputStream();
            if (output instanceof HttpOutput) {
                HttpOutput httpOutput = (HttpOutput)output;
                int len = 0;
                try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
                    while (iterator.hasNext() && httpOutput.isReady()) {
                        ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                        len += byteBuffer.remaining();
                        httpOutput.write(byteBuffer);
                    }
                }
                return len;
            }
            return super.writeToOutputStream(dataBuffer);
        }
    }
}

