/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBufferFactory;
import keycloakjar.org.springframework.http.HttpCookie;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import keycloakjar.org.springframework.http.server.reactive.AbstractServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.DefaultSslInfo;
import keycloakjar.org.springframework.http.server.reactive.SslInfo;
import keycloakjar.org.springframework.lang.NonNull;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedCaseInsensitiveMap;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.util.UriComponentsBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class ServletServerHttpRequest
extends AbstractServerHttpRequest {
    static final DataBuffer EOF_BUFFER = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
    private final HttpServletRequest request;
    private final ServletInputStream inputStream;
    private final RequestBodyPublisher bodyPublisher;
    private final Object cookieLock = new Object();
    private final DataBufferFactory bufferFactory;
    private final byte[] buffer;
    private final AsyncListener asyncListener;

    public ServletServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
        this(ServletServerHttpRequest.createDefaultHttpHeaders(request), request, asyncContext, servletPath, bufferFactory, bufferSize);
    }

    public ServletServerHttpRequest(MultiValueMap<String, String> headers, HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
        super(HttpMethod.valueOf(request.getMethod()), ServletServerHttpRequest.initUri(request), request.getContextPath() + servletPath, ServletServerHttpRequest.initHeaders(headers, request));
        Assert.notNull((Object)bufferFactory, "'bufferFactory' must not be null");
        Assert.isTrue(bufferSize > 0, "'bufferSize' must be greater than 0");
        this.request = request;
        this.bufferFactory = bufferFactory;
        this.buffer = new byte[bufferSize];
        this.asyncListener = new RequestAsyncListener();
        this.inputStream = request.getInputStream();
        this.bodyPublisher = new RequestBodyPublisher(this.inputStream);
        this.bodyPublisher.registerReadListener();
    }

    private static MultiValueMap<String, String> createDefaultHttpHeaders(HttpServletRequest request) {
        MultiValueMap<String, String> headers = CollectionUtils.toMultiValueMap(new LinkedCaseInsensitiveMap(8, Locale.ROOT));
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name, (String)values.nextElement());
            }
        }
        return headers;
    }

    private static URI initUri(HttpServletRequest servletRequest) {
        Assert.notNull((Object)servletRequest, "'request' must not be null");
        String urlString = null;
        String query = null;
        boolean hasQuery = false;
        try {
            StringBuffer requestURL = servletRequest.getRequestURL();
            query = servletRequest.getQueryString();
            hasQuery = StringUtils.hasText(query);
            if (hasQuery) {
                requestURL.append('?').append(query);
            }
            urlString = requestURL.toString();
            return new URI(urlString);
        }
        catch (URISyntaxException ex) {
            if (hasQuery) {
                try {
                    query = UriComponentsBuilder.fromUriString("?" + query).build().toUri().getRawQuery();
                    return new URI(servletRequest.getRequestURL().toString() + "?" + query);
                }
                catch (URISyntaxException ex2) {
                    try {
                        return new URI(servletRequest.getRequestURL().toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
            throw new IllegalStateException("Could not resolve HttpServletRequest as URI: " + urlString, ex);
        }
    }

    private static MultiValueMap<String, String> initHeaders(MultiValueMap<String, String> headerValues, HttpServletRequest request) {
        int contentLength;
        String encoding;
        String requestContentType;
        HttpHeaders headers = null;
        MimeType contentType = null;
        if (!StringUtils.hasLength(headerValues.getFirst((String)"Content-Type")) && StringUtils.hasLength(requestContentType = request.getContentType())) {
            contentType = MediaType.parseMediaType(requestContentType);
            headers = new HttpHeaders(headerValues);
            headers.setContentType((MediaType)contentType);
        }
        if (contentType != null && contentType.getCharset() == null && StringUtils.hasLength(encoding = request.getCharacterEncoding())) {
            LinkedCaseInsensitiveMap<String> params = new LinkedCaseInsensitiveMap<String>();
            params.putAll(contentType.getParameters());
            params.put("charset", Charset.forName(encoding).toString());
            headers.setContentType(new MediaType((MediaType)contentType, params));
        }
        if (headerValues.getFirst((String)"Content-Type") == null && (contentLength = request.getContentLength()) != -1) {
            headers = headers != null ? headers : new HttpHeaders(headerValues);
            headers.setContentLength(contentLength);
        }
        return headers != null ? headers : headerValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap<String, HttpCookie> httpCookies = new LinkedMultiValueMap<String, HttpCookie>();
        Cookie[] cookieArray = this.cookieLock;
        synchronized (this.cookieLock) {
            Cookie[] cookies = this.request.getCookies();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
                    httpCookies.add(name, httpCookie);
                }
            }
            return httpCookies;
        }
    }

    @Override
    @NonNull
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    @Override
    @NonNull
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.request.getRemoteHost(), this.request.getRemotePort());
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        X509Certificate[] certificates = this.getX509Certificates();
        return certificates != null ? new DefaultSslInfo(this.getSslSessionId(), certificates) : null;
    }

    @Nullable
    private String getSslSessionId() {
        return (String)this.request.getAttribute("jakarta.servlet.request.ssl_session_id");
    }

    @Nullable
    private X509Certificate[] getX509Certificates() {
        return (X509Certificate[])this.request.getAttribute("jakarta.servlet.request.X509Certificate");
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.bodyPublisher);
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    AsyncListener getAsyncListener() {
        return this.asyncListener;
    }

    protected final ServletInputStream getInputStream() {
        return this.inputStream;
    }

    DataBuffer readFromInputStream() throws IOException {
        int read = this.inputStream.read(this.buffer);
        this.logBytesRead(read);
        if (read > 0) {
            DataBuffer dataBuffer = this.bufferFactory.allocateBuffer(read);
            dataBuffer.write(this.buffer, 0, read);
            return dataBuffer;
        }
        if (read == -1) {
            return EOF_BUFFER;
        }
        return AbstractListenerReadPublisher.EMPTY_BUFFER;
    }

    protected final void logBytesRead(int read) {
        Log rsReadLogger = AbstractListenerReadPublisher.rsReadLogger;
        if (rsReadLogger.isTraceEnabled()) {
            rsReadLogger.trace(this.getLogPrefix() + "Read " + read + (read != -1 ? " bytes" : ""));
        }
    }

    private final class RequestAsyncListener
    implements AsyncListener {
        private RequestAsyncListener() {
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            ex = ex != null ? ex : new IllegalStateException("Async operation timeout.");
            ServletServerHttpRequest.this.bodyPublisher.onError(ex);
        }

        public void onError(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onError(event.getThrowable());
        }

        public void onComplete(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onAllDataRead();
        }
    }

    private class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final ServletInputStream inputStream;

        public RequestBodyPublisher(ServletInputStream inputStream) {
            super(ServletServerHttpRequest.this.getLogPrefix());
            this.inputStream = inputStream;
        }

        public void registerReadListener() throws IOException {
            this.inputStream.setReadListener((ReadListener)new RequestBodyPublisherReadListener());
        }

        @Override
        protected void checkOnDataAvailable() {
            if (this.inputStream.isReady() && !this.inputStream.isFinished()) {
                this.onDataAvailable();
            }
        }

        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            if (this.inputStream.isReady()) {
                DataBuffer dataBuffer = ServletServerHttpRequest.this.readFromInputStream();
                if (dataBuffer == EOF_BUFFER) {
                    this.onAllDataRead();
                    dataBuffer = null;
                }
                return dataBuffer;
            }
            return null;
        }

        @Override
        protected void readingPaused() {
        }

        @Override
        protected void discardData() {
        }

        private class RequestBodyPublisherReadListener
        implements ReadListener {
            private RequestBodyPublisherReadListener() {
            }

            public void onDataAvailable() throws IOException {
                RequestBodyPublisher.this.onDataAvailable();
            }

            public void onAllDataRead() throws IOException {
                RequestBodyPublisher.this.onAllDataRead();
            }

            public void onError(Throwable throwable) {
                RequestBodyPublisher.this.onError(throwable);
            }
        }
    }
}

