/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import java.util.concurrent.atomic.AtomicReference;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.core.log.LogDelegateFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;

class WriteResultPublisher
implements Publisher<Void> {
    private static final Log rsWriteResultLogger = LogDelegateFactory.getHiddenLog(WriteResultPublisher.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private final Runnable cancelTask;
    @Nullable
    private volatile Subscriber<? super Void> subscriber;
    private volatile boolean completedBeforeSubscribed;
    @Nullable
    private volatile Throwable errorBeforeSubscribed;
    private final String logPrefix;

    public WriteResultPublisher(String logPrefix, Runnable cancelTask) {
        this.cancelTask = cancelTask;
        this.logPrefix = logPrefix;
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        if (rsWriteResultLogger.isTraceEnabled()) {
            rsWriteResultLogger.trace(this.logPrefix + "got subscriber " + String.valueOf(subscriber));
        }
        this.state.get().subscribe(this, subscriber);
    }

    public void publishComplete() {
        State state = this.state.get();
        if (rsWriteResultLogger.isTraceEnabled()) {
            rsWriteResultLogger.trace(this.logPrefix + "completed [" + String.valueOf((Object)state) + "]");
        }
        state.publishComplete(this);
    }

    public void publishError(Throwable t2) {
        State state = this.state.get();
        if (rsWriteResultLogger.isTraceEnabled()) {
            rsWriteResultLogger.trace(this.logPrefix + "failed: " + String.valueOf(t2) + " [" + String.valueOf((Object)state) + "]");
        }
        state.publishError(this, t2);
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        UNSUBSCRIBED{

            @Override
            void subscribe(WriteResultPublisher publisher, Subscriber<? super Void> subscriber) {
                Assert.notNull(subscriber, "Subscriber must not be null");
                if (publisher.changeState(this, SUBSCRIBING)) {
                    Throwable ex;
                    WriteResultSubscription subscription = new WriteResultSubscription(publisher);
                    publisher.subscriber = subscriber;
                    subscriber.onSubscribe((Subscription)subscription);
                    publisher.changeState(SUBSCRIBING, SUBSCRIBED);
                    if (publisher.completedBeforeSubscribed) {
                        publisher.state.get().publishComplete(publisher);
                    }
                    if ((ex = publisher.errorBeforeSubscribed) != null) {
                        publisher.state.get().publishError(publisher, ex);
                    }
                } else {
                    throw new IllegalStateException(this.toString());
                }
            }

            @Override
            void publishComplete(WriteResultPublisher publisher) {
                publisher.completedBeforeSubscribed = true;
                if (SUBSCRIBED == publisher.state.get()) {
                    publisher.state.get().publishComplete(publisher);
                }
            }

            @Override
            void publishError(WriteResultPublisher publisher, Throwable ex) {
                publisher.errorBeforeSubscribed = ex;
                if (SUBSCRIBED == publisher.state.get()) {
                    publisher.state.get().publishError(publisher, ex);
                }
            }
        }
        ,
        SUBSCRIBING{

            @Override
            void request(WriteResultPublisher publisher, long n) {
                Operators.validate((long)n);
            }

            @Override
            void publishComplete(WriteResultPublisher publisher) {
                publisher.completedBeforeSubscribed = true;
                if (SUBSCRIBED == publisher.state.get()) {
                    publisher.state.get().publishComplete(publisher);
                }
            }

            @Override
            void publishError(WriteResultPublisher publisher, Throwable ex) {
                publisher.errorBeforeSubscribed = ex;
                if (SUBSCRIBED == publisher.state.get()) {
                    publisher.state.get().publishError(publisher, ex);
                }
            }
        }
        ,
        SUBSCRIBED{

            @Override
            void request(WriteResultPublisher publisher, long n) {
                Operators.validate((long)n);
            }
        }
        ,
        COMPLETED{

            @Override
            void request(WriteResultPublisher publisher, long n) {
            }

            @Override
            void cancel(WriteResultPublisher publisher) {
            }

            @Override
            void publishComplete(WriteResultPublisher publisher) {
            }

            @Override
            void publishError(WriteResultPublisher publisher, Throwable t2) {
            }
        };


        void subscribe(WriteResultPublisher publisher, Subscriber<? super Void> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        void request(WriteResultPublisher publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        void cancel(WriteResultPublisher publisher) {
            if (publisher.changeState(this, COMPLETED)) {
                publisher.cancelTask.run();
            } else {
                publisher.state.get().cancel(publisher);
            }
        }

        void publishComplete(WriteResultPublisher publisher) {
            if (publisher.changeState(this, COMPLETED)) {
                Subscriber<? super Void> s2 = publisher.subscriber;
                Assert.state(s2 != null, "No subscriber");
                s2.onComplete();
            } else {
                publisher.state.get().publishComplete(publisher);
            }
        }

        void publishError(WriteResultPublisher publisher, Throwable t2) {
            if (publisher.changeState(this, COMPLETED)) {
                Subscriber<? super Void> s2 = publisher.subscriber;
                Assert.state(s2 != null, "No subscriber");
                s2.onError(t2);
            } else {
                publisher.state.get().publishError(publisher, t2);
            }
        }
    }

    private static final class WriteResultSubscription
    implements Subscription {
        private final WriteResultPublisher publisher;

        public WriteResultSubscription(WriteResultPublisher publisher) {
            this.publisher = publisher;
        }

        public final void request(long n) {
            if (rsWriteResultLogger.isTraceEnabled()) {
                rsWriteResultLogger.trace(this.publisher.logPrefix + "request " + String.valueOf(n != Long.MAX_VALUE ? Long.valueOf(n) : "Long.MAX_VALUE"));
            }
            this.getState().request(this.publisher, n);
        }

        public final void cancel() {
            State state = this.getState();
            if (rsWriteResultLogger.isTraceEnabled()) {
                rsWriteResultLogger.trace(this.publisher.logPrefix + "cancel [" + String.valueOf((Object)state) + "]");
            }
            state.cancel(this.publisher);
        }

        private State getState() {
            return this.publisher.state.get();
        }
    }
}

