/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util;

import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.MultiToSingleValueMapAdapter;
import keycloakjar.org.springframework.util.MultiValueMapAdapter;
import keycloakjar.org.springframework.util.SingleToMultiValueMapAdapter;

public interface MultiValueMap<K, V>
extends Map<K, List<V>> {
    @Nullable
    public V getFirst(K var1);

    public void add(K var1, @Nullable V var2);

    public void addAll(K var1, List<? extends V> var2);

    public void addAll(MultiValueMap<K, V> var1);

    default public void addIfAbsent(K key, @Nullable V value) {
        if (!this.containsKey(key)) {
            this.add(key, value);
        }
    }

    public void set(K var1, @Nullable V var2);

    public void setAll(Map<K, V> var1);

    public Map<K, V> toSingleValueMap();

    default public Map<K, V> asSingleValueMap() {
        return new MultiToSingleValueMapAdapter(this);
    }

    public static <K, V> MultiValueMap<K, V> fromSingleValue(Map<K, V> map) {
        Assert.notNull(map, "Map must not be null");
        return new SingleToMultiValueMapAdapter<K, V>(map);
    }

    public static <K, V> MultiValueMap<K, V> fromMultiValue(Map<K, List<V>> map) {
        Assert.notNull(map, "Map must not be null");
        return new MultiValueMapAdapter<K, V>(map);
    }
}

