/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.accept;

import java.util.Arrays;
import java.util.List;
import keycloakjar.org.springframework.http.InvalidMediaTypeException;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.InvalidMimeTypeException;
import keycloakjar.org.springframework.util.MimeTypeUtils;
import keycloakjar.org.springframework.web.HttpMediaTypeNotAcceptableException;
import keycloakjar.org.springframework.web.accept.ContentNegotiationStrategy;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;

public class HeaderContentNegotiationStrategy
implements ContentNegotiationStrategy {
    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        String[] headerValueArray = request.getHeaderValues("Accept");
        if (headerValueArray == null) {
            return MEDIA_TYPE_ALL_LIST;
        }
        List<String> headerValues = Arrays.asList(headerValueArray);
        try {
            List mediaTypes = MediaType.parseMediaTypes(headerValues);
            MimeTypeUtils.sortBySpecificity(mediaTypes);
            return !CollectionUtils.isEmpty(mediaTypes) ? mediaTypes : MEDIA_TYPE_ALL_LIST;
        }
        catch (InvalidMediaTypeException | InvalidMimeTypeException ex) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header " + String.valueOf(headerValues) + ": " + ex.getMessage());
        }
    }
}

