/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.io.IOException;
import java.nio.charset.Charset;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.FileCopyUtils;

abstract class RestClientUtils {
    RestClientUtils() {
    }

    public static byte[] getBody(HttpInputMessage message) {
        try {
            return FileCopyUtils.copyToByteArray(message.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    @Nullable
    public static Charset getCharset(HttpMessage response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

