/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.cors.reactive;

import keycloakjar.org.springframework.http.server.reactive.ServerHttpRequest;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.cors.CorsConfiguration;
import keycloakjar.org.springframework.web.cors.reactive.CorsConfigurationSource;
import keycloakjar.org.springframework.web.cors.reactive.CorsProcessor;
import keycloakjar.org.springframework.web.cors.reactive.CorsUtils;
import keycloakjar.org.springframework.web.cors.reactive.DefaultCorsProcessor;
import keycloakjar.org.springframework.web.server.ServerWebExchange;
import keycloakjar.org.springframework.web.server.WebFilter;
import keycloakjar.org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CorsWebFilter
implements WebFilter {
    private final CorsConfigurationSource configSource;
    private final CorsProcessor processor;

    public CorsWebFilter(CorsConfigurationSource configSource) {
        this(configSource, new DefaultCorsProcessor());
    }

    public CorsWebFilter(CorsConfigurationSource configSource, CorsProcessor processor) {
        Assert.notNull((Object)configSource, "CorsConfigurationSource must not be null");
        Assert.notNull((Object)processor, "CorsProcessor must not be null");
        this.configSource = configSource;
        this.processor = processor;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        ServerHttpRequest request = exchange2.getRequest();
        CorsConfiguration corsConfiguration = this.configSource.getCorsConfiguration(exchange2);
        boolean isValid = this.processor.process(corsConfiguration, exchange2);
        if (!isValid || CorsUtils.isPreFlightRequest(request)) {
            return Mono.empty();
        }
        return chain.filter(exchange2);
    }
}

