/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.annotation;

import jakarta.validation.Validator;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import keycloakjar.org.springframework.core.Conventions;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ParameterNameDiscoverer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.validation.BindingResult;
import keycloakjar.org.springframework.validation.Errors;
import keycloakjar.org.springframework.validation.MessageCodesResolver;
import keycloakjar.org.springframework.validation.SmartValidator;
import keycloakjar.org.springframework.validation.beanvalidation.MethodValidationAdapter;
import keycloakjar.org.springframework.validation.method.MethodValidationResult;
import keycloakjar.org.springframework.validation.method.MethodValidator;
import keycloakjar.org.springframework.validation.method.ParameterErrors;
import keycloakjar.org.springframework.web.bind.annotation.RequestBody;
import keycloakjar.org.springframework.web.bind.annotation.RequestPart;
import keycloakjar.org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import keycloakjar.org.springframework.web.bind.support.WebBindingInitializer;
import keycloakjar.org.springframework.web.method.annotation.HandlerMethodValidationException;
import keycloakjar.org.springframework.web.method.annotation.ModelFactory;

public final class HandlerMethodValidator
implements MethodValidator {
    private static final MethodValidationAdapter.ObjectNameResolver objectNameResolver = new WebObjectNameResolver();
    private final MethodValidationAdapter validationAdapter;
    private final Predicate<MethodParameter> modelAttributePredicate;
    private final Predicate<MethodParameter> requestParamPredicate;

    private HandlerMethodValidator(MethodValidationAdapter validationAdapter, Predicate<MethodParameter> modelAttributePredicate, Predicate<MethodParameter> requestParamPredicate) {
        this.validationAdapter = validationAdapter;
        this.modelAttributePredicate = modelAttributePredicate;
        this.requestParamPredicate = requestParamPredicate;
    }

    public Class<?>[] determineValidationGroups(Object target, Method method) {
        return this.validationAdapter.determineValidationGroups(target, method);
    }

    public void applyArgumentValidation(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        MethodValidationResult result = this.validateArguments(target, method, parameters, arguments, groups);
        if (!result.hasErrors()) {
            return;
        }
        if (!result.getBeanResults().isEmpty()) {
            int bindingResultCount = 0;
            block0: for (ParameterErrors errors : result.getBeanResults()) {
                for (Object arg : arguments) {
                    BindingResult bindingResult;
                    if (!(arg instanceof BindingResult) || !(bindingResult = (BindingResult)arg).getObjectName().equals(errors.getObjectName())) continue;
                    bindingResult.addAllErrors((Errors)errors);
                    ++bindingResultCount;
                    continue block0;
                }
            }
            if (result.getParameterValidationResults().size() == bindingResultCount) {
                return;
            }
        }
        throw new HandlerMethodValidationException(result, this.modelAttributePredicate, this.requestParamPredicate);
    }

    public MethodValidationResult validateArguments(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        return this.validationAdapter.validateArguments(target, method, parameters, arguments, (Class[])groups);
    }

    public void applyReturnValueValidation(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        MethodValidationResult result = this.validateReturnValue(target, method, returnType, returnValue, groups);
        if (result.hasErrors()) {
            throw new HandlerMethodValidationException(result);
        }
    }

    public MethodValidationResult validateReturnValue(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        return this.validationAdapter.validateReturnValue(target, method, returnType, returnValue, (Class[])groups);
    }

    @Nullable
    public static MethodValidator from(@Nullable WebBindingInitializer initializer, @Nullable ParameterNameDiscoverer paramNameDiscoverer, Predicate<MethodParameter> modelAttributePredicate, Predicate<MethodParameter> requestParamPredicate) {
        ConfigurableWebBindingInitializer configurableInitializer;
        Validator validator;
        if (initializer instanceof ConfigurableWebBindingInitializer && (validator = HandlerMethodValidator.getValidator(configurableInitializer = (ConfigurableWebBindingInitializer)initializer)) != null) {
            MessageCodesResolver codesResolver;
            MethodValidationAdapter adapter = new MethodValidationAdapter(validator);
            adapter.setObjectNameResolver(objectNameResolver);
            if (paramNameDiscoverer != null) {
                adapter.setParameterNameDiscoverer(paramNameDiscoverer);
            }
            if ((codesResolver = configurableInitializer.getMessageCodesResolver()) != null) {
                adapter.setMessageCodesResolver(codesResolver);
            }
            return new HandlerMethodValidator(adapter, modelAttributePredicate, requestParamPredicate);
        }
        return null;
    }

    @Nullable
    private static Validator getValidator(ConfigurableWebBindingInitializer initializer) {
        keycloakjar.org.springframework.validation.Validator validator = initializer.getValidator();
        if (validator instanceof Validator) {
            Validator validator2 = (Validator)validator;
            return validator2;
        }
        validator = initializer.getValidator();
        if (validator instanceof SmartValidator) {
            SmartValidator smartValidator = (SmartValidator)validator;
            return (Validator)smartValidator.unwrap(Validator.class);
        }
        return null;
    }

    private static class WebObjectNameResolver
    implements MethodValidationAdapter.ObjectNameResolver {
        private WebObjectNameResolver() {
        }

        public String resolveName(MethodParameter param, @Nullable Object value) {
            if (param.hasParameterAnnotation(RequestBody.class) || param.hasParameterAnnotation(RequestPart.class)) {
                return Conventions.getVariableNameForParameter(param);
            }
            return param.getParameterIndex() != -1 ? ModelFactory.getNameForParameter(param) : ModelFactory.getNameForReturnValue(value, param);
        }
    }
}

