/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.util;

import java.util.Locale;
import java.util.Set;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.core.log.LogDelegateFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.util.HierarchicalUriComponents;
import keycloakjar.org.springframework.web.util.InvalidUrlException;

abstract class RfcUriParser {
    private static final Log logger = LogDelegateFactory.getHiddenLog(RfcUriParser.class);

    RfcUriParser() {
    }

    public static UriRecord parse(String uri) {
        return new InternalParser(uri).parse();
    }

    private static void verify(boolean expression, InternalParser parser, String message) {
        if (!expression) {
            RfcUriParser.fail(parser, message);
        }
    }

    private static void verifyIsHexDigit(char c, InternalParser parser, String message) {
        RfcUriParser.verify(c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9', parser, message);
    }

    private static void fail(InternalParser parser, String message) {
        if (logger.isTraceEnabled()) {
            logger.trace(InvalidUrlException.class.getSimpleName() + ": \"" + message + "\" " + String.valueOf(parser));
        }
        throw new InvalidUrlException(message);
    }

    private static class InternalParser {
        private static final Set<String> hierarchicalSchemes = Set.of("ftp", "file", "http", "https", "ws", "wss");
        private final String uri;
        @Nullable
        private String scheme;
        @Nullable
        String user;
        @Nullable
        private String host;
        @Nullable
        private String path;
        @Nullable
        String port;
        @Nullable
        String query;
        @Nullable
        String fragment;
        private State state = State.START;
        private int index;
        private int componentIndex;
        boolean isOpaque;
        private int remainingPercentEncodedChars;
        private boolean inUtf16Sequence;
        private boolean inPassword;
        private int openCurlyBracketCount;

        public InternalParser(String uri) {
            this.uri = uri;
        }

        public boolean hasScheme() {
            return this.scheme != null;
        }

        public boolean isOpaque() {
            return this.isOpaque;
        }

        public boolean hasUser() {
            return this.user != null;
        }

        public boolean hasHost() {
            return this.host != null;
        }

        public boolean isAtStartOfComponent() {
            return this.index == this.componentIndex;
        }

        public UriRecord parse() {
            Assert.isTrue(this.state == State.START && this.index == 0, "Internal Error");
            while (this.hasNext()) {
                this.state.handleNext(this, this.charAtIndex(), this.index);
                ++this.index;
            }
            this.state.handleEnd(this);
            return new UriRecord(this.scheme, this.isOpaque, this.user, this.host, this.port, this.path, this.query, this.fragment);
        }

        public boolean hasNext() {
            return this.index < this.uri.length();
        }

        public char charAtIndex() {
            return this.uri.charAt(this.index);
        }

        public void advanceTo(State state) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf((Object)this.state) + " -> " + String.valueOf((Object)state) + ", index=" + this.index + ", componentIndex=" + this.componentIndex);
            }
            this.state = state;
            this.openCurlyBracketCount = 0;
        }

        public void advanceTo(State state, int componentIndex) {
            this.componentIndex = componentIndex;
            this.advanceTo(state);
        }

        public InternalParser componentIndex(int componentIndex) {
            this.componentIndex = componentIndex;
            return this;
        }

        public void index(int index) {
            this.index = index;
        }

        public InternalParser resolveIfOpaque() {
            boolean hasSlash = this.uri.indexOf(47, this.index + 1) == -1;
            this.isOpaque = hasSlash && !hierarchicalSchemes.contains(this.scheme);
            return this;
        }

        public InternalParser captureScheme() {
            String scheme = this.captureComponent("scheme");
            this.scheme = !scheme.contains("{") ? scheme.toLowerCase(Locale.ROOT) : scheme;
            return this;
        }

        public InternalParser captureUser() {
            this.inPassword = false;
            this.user = this.captureComponent("user");
            return this;
        }

        public InternalParser captureHost() {
            RfcUriParser.verify(this.remainingPercentEncodedChars == 0 && !this.inPassword, this, "Bad authority");
            this.host = this.captureComponent("host");
            return this;
        }

        public InternalParser captureHostIfNotEmpty() {
            if (this.index > this.componentIndex) {
                this.captureHost();
            }
            return this;
        }

        public InternalParser capturePort() {
            RfcUriParser.verify(this.openCurlyBracketCount == 0, this, "Bad authority");
            this.port = this.captureComponent("port");
            return this;
        }

        public InternalParser capturePath() {
            this.path = this.captureComponent("path");
            return this;
        }

        public InternalParser captureQuery() {
            this.query = this.captureComponent("query");
            return this;
        }

        public void captureFragmentIfNotEmpty() {
            if (this.index > this.componentIndex + 1) {
                this.fragment = this.captureComponent("fragment");
            }
        }

        public InternalParser switchPortForFullPassword() {
            this.user = this.host + ":" + this.captureComponent();
            if (logger.isTraceEnabled()) {
                logger.trace("Switching from host/port to user=" + this.user);
            }
            return this;
        }

        public InternalParser switchPortForPassword() {
            this.inPassword = true;
            if (this.host != null) {
                this.componentIndex = this.componentIndex - this.host.length() - 1;
                this.host = null;
                if (logger.isTraceEnabled()) {
                    logger.trace("Switching from host/port to username/password");
                }
            }
            return this;
        }

        private String captureComponent(String logPrefix) {
            String value = this.captureComponent();
            if (logger.isTraceEnabled()) {
                logger.trace(logPrefix + " set to '" + value + "'");
            }
            return value;
        }

        private String captureComponent() {
            return this.uri.substring(this.componentIndex, this.index);
        }

        public InternalParser markPercentEncoding() {
            RfcUriParser.verify(this.remainingPercentEncodedChars == 0, this, "Bad encoding");
            this.remainingPercentEncodedChars = 2;
            this.inUtf16Sequence = false;
            return this;
        }

        public boolean countDownPercentEncodingInHost(char c) {
            if (this.remainingPercentEncodedChars == 0) {
                return false;
            }
            --this.remainingPercentEncodedChars;
            RfcUriParser.verifyIsHexDigit(c, this, "Bad authority");
            return true;
        }

        public boolean countDownPercentEncodingInPath(char c) {
            if (this.remainingPercentEncodedChars == 0) {
                return false;
            }
            if (this.remainingPercentEncodedChars == 2 && c == 'u' && !this.inUtf16Sequence) {
                this.inUtf16Sequence = true;
                this.remainingPercentEncodedChars = 4;
                return true;
            }
            --this.remainingPercentEncodedChars;
            RfcUriParser.verifyIsHexDigit(c, this, "Bad path");
            this.inUtf16Sequence &= this.remainingPercentEncodedChars > 0;
            return true;
        }

        public boolean processCurlyBrackets(char c) {
            if (c == '{') {
                ++this.openCurlyBracketCount;
                return true;
            }
            if (c == '}') {
                if (this.openCurlyBracketCount > 0) {
                    --this.openCurlyBracketCount;
                    return true;
                }
                return false;
            }
            return this.openCurlyBracketCount > 0;
        }

        public String toString() {
            return "[State=" + String.valueOf((Object)this.state) + ", index=" + this.index + ", componentIndex=" + this.componentIndex + ", uri='" + this.uri + "', scheme='" + this.scheme + "', user='" + this.user + "', host='" + this.host + "', path='" + this.path + "', port='" + this.port + "', query='" + this.query + "', fragment='" + this.fragment + "']";
        }
    }

    record UriRecord(@Nullable String scheme, boolean isOpaque, @Nullable String user, @Nullable String host, @Nullable String port, @Nullable String path, @Nullable String query, @Nullable String fragment) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        START{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                switch (c) {
                    case '/': {
                        parser.advanceTo(HOST_OR_PATH, i);
                        break;
                    }
                    case '.': 
                    case ';': {
                        parser.advanceTo(PATH, i);
                        break;
                    }
                    case '%': {
                        parser.markPercentEncoding().advanceTo(PATH, i);
                        break;
                    }
                    case '?': {
                        parser.advanceTo(QUERY, i + 1);
                        break;
                    }
                    case '#': {
                        parser.advanceTo(FRAGMENT, i + 1);
                        break;
                    }
                    case '*': {
                        parser.advanceTo(WILDCARD);
                        break;
                    }
                    default: {
                        if (parser.hasScheme()) {
                            parser.resolveIfOpaque().advanceTo(PATH, i);
                            break;
                        }
                        parser.advanceTo(SCHEME_OR_PATH, i);
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePath();
            }
        }
        ,
        HOST_OR_PATH{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                switch (c) {
                    case '/': {
                        parser.componentIndex(i).captureHost().advanceTo(HOST, i + 1);
                        break;
                    }
                    case '#': 
                    case '%': 
                    case '.': 
                    case ';': 
                    case '?': 
                    case '@': {
                        parser.index(--i);
                        parser.advanceTo(PATH);
                        break;
                    }
                    default: {
                        parser.advanceTo(PATH);
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePath();
            }
        }
        ,
        SCHEME_OR_PATH{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                switch (c) {
                    case ':': {
                        parser.captureScheme().advanceTo(START);
                        break;
                    }
                    case '/': 
                    case ';': {
                        parser.advanceTo(PATH);
                        break;
                    }
                    case '%': {
                        parser.markPercentEncoding().advanceTo(PATH);
                        break;
                    }
                    case '?': {
                        parser.capturePath().advanceTo(QUERY, i + 1);
                        break;
                    }
                    case '#': {
                        parser.capturePath().advanceTo(FRAGMENT);
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePath();
            }
        }
        ,
        HOST{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                switch (c) {
                    case '/': {
                        parser.captureHost().advanceTo(PATH, i);
                        break;
                    }
                    case ':': {
                        parser.captureHostIfNotEmpty().advanceTo(PORT, i + 1);
                        break;
                    }
                    case '?': {
                        parser.captureHostIfNotEmpty().advanceTo(QUERY, i + 1);
                        break;
                    }
                    case '#': {
                        parser.captureHostIfNotEmpty().advanceTo(FRAGMENT, i + 1);
                        break;
                    }
                    case '@': {
                        parser.captureUser().componentIndex(i + 1);
                        break;
                    }
                    case '[': {
                        RfcUriParser.verify(parser.isAtStartOfComponent(), parser, "Bad authority");
                        parser.advanceTo(IPV6);
                        break;
                    }
                    case '%': {
                        parser.markPercentEncoding();
                        break;
                    }
                    default: {
                        boolean isAllowed = parser.processCurlyBrackets(c) || parser.countDownPercentEncodingInHost(c) || HierarchicalUriComponents.Type.URI.isUnreservedOrSubDelimiter(c);
                        RfcUriParser.verify(isAllowed, parser, "Bad authority");
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.captureHostIfNotEmpty();
            }
        }
        ,
        IPV6{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                switch (c) {
                    case ']': {
                        parser.index(++i);
                        parser.captureHost();
                        if (!parser.hasNext()) break;
                        if (parser.charAtIndex() == ':') {
                            parser.advanceTo(PORT, i + 1);
                            break;
                        }
                        parser.advanceTo(PATH, i);
                        break;
                    }
                    case ':': {
                        break;
                    }
                    default: {
                        RfcUriParser.verifyIsHexDigit(c, parser, "Bad authority");
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                RfcUriParser.verify(parser.hasHost(), parser, "Bad authority");
            }
        }
        ,
        PORT{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                if (c == '@') {
                    RfcUriParser.verify(!parser.hasUser(), parser, "Bad authority");
                    parser.switchPortForFullPassword().advanceTo(HOST, i + 1);
                } else if (c == '/') {
                    parser.capturePort().advanceTo(PATH, i);
                } else if (c == '?' || c == '#') {
                    parser.capturePort().advanceTo(c == '?' ? QUERY : FRAGMENT, i + 1);
                } else if (!Character.isDigit(c)) {
                    if (parser.processCurlyBrackets(c)) {
                        return;
                    }
                    if (HierarchicalUriComponents.Type.URI.isUnreservedOrSubDelimiter(c) || c == '%') {
                        parser.switchPortForPassword().advanceTo(HOST);
                        return;
                    }
                    RfcUriParser.fail(parser, "Bad authority");
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePort();
            }
        }
        ,
        PATH{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                if (!parser.countDownPercentEncodingInPath(c)) {
                    switch (c) {
                        case '?': {
                            if (parser.isOpaque()) break;
                            parser.capturePath().advanceTo(QUERY, i + 1);
                            break;
                        }
                        case '#': {
                            parser.capturePath().advanceTo(FRAGMENT, i + 1);
                            break;
                        }
                        case '%': {
                            parser.markPercentEncoding();
                        }
                    }
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePath();
            }
        }
        ,
        QUERY{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                if (c == '#') {
                    parser.captureQuery().advanceTo(FRAGMENT, i + 1);
                }
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.captureQuery();
            }
        }
        ,
        FRAGMENT{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.captureFragmentIfNotEmpty();
            }
        }
        ,
        WILDCARD{

            @Override
            public void handleNext(InternalParser parser, char c, int i) {
                RfcUriParser.fail(parser, "Bad character '*'");
            }

            @Override
            public void handleEnd(InternalParser parser) {
                parser.capturePath();
            }
        };


        public abstract void handleNext(InternalParser var1, char var2, int var3);

        public abstract void handleEnd(InternalParser var1);
    }
}

