/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import keycloakjar.com.google.gson.JsonArray;
import keycloakjar.com.google.gson.JsonObject;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.ResponseEntity;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.util.UriComponentsBuilder;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;

public abstract class KeycloakServiceBase {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakRestTemplate restTemplate;
    protected KeycloakContextProvider keycloakContextProvider;

    public KeycloakServiceBase(KeycloakConfiguration keycloakConfiguration, KeycloakRestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
        this.keycloakContextProvider = keycloakContextProvider;
    }

    protected String getKeycloakUserID(String userId) throws KeycloakUserNotFoundException, RestClientException {
        String userSearch;
        if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
            userSearch = "/users?exact=true&email=";
        } else if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            userSearch = "/users?exact=true&username=";
        } else {
            return userId;
        }
        try {
            URI uri = UriComponentsBuilder.fromUriString(this.keycloakConfiguration.getKeycloakAdminUrl() + userSearch + URLEncoder.encode(userId, StandardCharsets.UTF_8.name())).build(true).toUri();
            ResponseEntity<String> response = this.restTemplate.exchange(uri, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class);
            JsonArray resultList = JsonUtil.parseAsJsonArray((String)response.getBody());
            JsonObject result = JsonUtil.findFirst(resultList, this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? "username" : "email", userId);
            if (result != null) {
                return JsonUtil.getJsonString(result, "id");
            }
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - username unknown"));
        }
        catch (JsonException je) {
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - username unknown"), je);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeycloakUserNotFoundException(userId + " not encodable", e);
        }
    }

    protected String getKeycloakGroupID(String groupId) throws KeycloakGroupNotFoundException, RestClientException {
        if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) {
            return groupId;
        }
        String groupSearch = "/group-by-path/" + groupId;
        try {
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + groupSearch, HttpMethod.GET, String.class, new Object[0]);
            return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response.getBody(), "id");
        }
        catch (JsonException je) {
            throw new KeycloakGroupNotFoundException(groupId + " not found - path unknown", je);
        }
    }

    protected String getMaxQueryResultSize() {
        return Integer.toString(this.keycloakConfiguration.getMaxResultSize());
    }

    protected <T> List<T> truncate(List<T> list, int maxSize) {
        if (list == null) {
            return list;
        }
        int actualSize = list.size();
        if (actualSize <= maxSize) {
            return list;
        }
        return list.subList(0, maxSize);
    }

    protected void addArgument(StringBuilder filter2, String name, String value) {
        if (filter2.length() > 0) {
            filter2.append("&");
        }
        filter2.append(name).append('=').append(value);
    }

    protected boolean matches(Object queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.equals(attribute);
    }

    protected boolean matches(Object[] queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.length == 0 || attribute != null && Arrays.asList(queryParameter).contains(attribute);
    }

    protected boolean matchesLike(String queryParameter, String attribute) {
        if (queryParameter == null) {
            return true;
        }
        if (attribute == null) {
            return queryParameter.replaceAll("[%\\*]", "").length() == 0;
        }
        return attribute.matches(queryParameter.replaceAll("[%\\*]", ".*"));
    }

    protected static int compare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    protected boolean isAuthenticatedUser(UserEntity user) {
        return this.isAuthenticatedUser(user.getId());
    }

    protected boolean isAuthenticatedUser(String userId) {
        if (userId == null) {
            return false;
        }
        return userId.equalsIgnoreCase(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        return !this.keycloakConfiguration.isAuthorizationCheckEnabled() || Context.getCommandContext().getAuthorizationManager().isAuthorized(permission, resource, resourceId);
    }
}

