/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.com.google.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import keycloakjar.com.google.gson.JsonElement;
import keycloakjar.com.google.gson.JsonIOException;
import keycloakjar.com.google.gson.JsonParseException;
import keycloakjar.com.google.gson.JsonSyntaxException;
import keycloakjar.com.google.gson.Strictness;
import keycloakjar.com.google.gson.internal.Streams;
import keycloakjar.com.google.gson.stream.JsonReader;
import keycloakjar.com.google.gson.stream.JsonToken;
import keycloakjar.com.google.gson.stream.MalformedJsonException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setStrictness(Strictness.LENIENT);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

