/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import keycloakjar.org.apache.hc.client5.http.impl.ConnPoolSupport;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.Experimental;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.concurrent.CallbackContribution;
import keycloakjar.org.apache.hc.core5.concurrent.CompletedFuture;
import keycloakjar.org.apache.hc.core5.concurrent.FutureCallback;
import keycloakjar.org.apache.hc.core5.http.HttpConnection;
import keycloakjar.org.apache.hc.core5.http.HttpVersion;
import keycloakjar.org.apache.hc.core5.http.ProtocolVersion;
import keycloakjar.org.apache.hc.core5.io.CloseMode;
import keycloakjar.org.apache.hc.core5.pool.ManagedConnPool;
import keycloakjar.org.apache.hc.core5.pool.PoolEntry;
import keycloakjar.org.apache.hc.core5.pool.PoolStats;
import keycloakjar.org.apache.hc.core5.util.Args;
import keycloakjar.org.apache.hc.core5.util.Asserts;
import keycloakjar.org.apache.hc.core5.util.TimeValue;
import keycloakjar.org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
@Experimental
public class H2SharingConnPool<T, C extends HttpConnection>
implements ManagedConnPool<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(H2SharingConnPool.class);
    private final ManagedConnPool<T, C> pool;
    private final ConcurrentMap<T, PerRoutePool<T, C>> perRouteCache;
    private final AtomicBoolean closed;

    public H2SharingConnPool(ManagedConnPool<T, C> pool) {
        this.pool = Args.notNull(pool, "Connection pool");
        this.perRouteCache = new ConcurrentHashMap<T, PerRoutePool<T, C>>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close(closeMode);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close();
        }
    }

    PerRoutePool<T, C> getPerRoutePool(T route) {
        return this.perRouteCache.computeIfAbsent(route, r -> new PerRoutePool());
    }

    @Override
    public Future<PoolEntry<T, C>> lease(final T route, final Object state, Timeout requestTimeout, final FutureCallback<PoolEntry<T, C>> callback) {
        PoolEntry entry;
        PerRoutePool perRoutePool;
        Asserts.check(!this.closed.get(), "Connection pool shut down");
        if (state == null && (perRoutePool = (PerRoutePool)this.perRouteCache.get(route)) != null && (entry = perRoutePool.lease()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sharing connection {} for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry.getConnection()), (Object)perRoutePool.getCount(entry));
            }
            CompletedFuture future = new CompletedFuture(entry);
            if (callback != null) {
                callback.completed(entry);
            }
            return future;
        }
        LOG.debug("No shared connection available");
        return this.pool.lease(route, state, requestTimeout, new CallbackContribution<PoolEntry<T, C>>(callback){

            @Override
            public void completed(PoolEntry<T, C> entry) {
                if (state == null) {
                    ProtocolVersion ver;
                    HttpConnection connection = (HttpConnection)entry.getConnection();
                    ProtocolVersion protocolVersion = ver = connection != null ? connection.getProtocolVersion() : null;
                    if (ver == HttpVersion.HTTP_2_0) {
                        PerRoutePool perRoutePool = H2SharingConnPool.this.getPerRoutePool(route);
                        long count = perRoutePool.track(entry);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection {} can be shared for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry.getConnection()), (Object)count);
                        }
                    }
                }
                if (callback != null) {
                    callback.completed(entry);
                }
            }
        });
    }

    @Override
    public void release(PoolEntry<T, C> entry, boolean reusable) {
        long count;
        if (entry == null) {
            return;
        }
        if (this.closed.get()) {
            this.pool.release(entry, reusable);
            return;
        }
        T route = entry.getRoute();
        PerRoutePool perRoutePool = (PerRoutePool)this.perRouteCache.get(route);
        if (perRoutePool != null && (count = perRoutePool.release(entry, reusable)) > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection {} is being shared for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry.getConnection()), (Object)count);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing connection {} back to the pool", (Object)ConnPoolSupport.getId(entry.getConnection()));
        }
        this.pool.release(entry, reusable);
    }

    @Override
    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(T route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    @Override
    public int getMaxPerRoute(T route) {
        return this.pool.getMaxPerRoute(route);
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        this.pool.closeIdle(idleTime);
    }

    @Override
    public void closeExpired() {
        this.pool.closeExpired();
    }

    @Override
    public Set<T> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(T route) {
        return this.pool.getStats(route);
    }

    public String toString() {
        return this.pool.toString();
    }

    static class PerRoutePool<T, C extends HttpConnection> {
        private final Map<PoolEntry<T, C>, AtomicLong> entryMap = new HashMap<PoolEntry<T, C>, AtomicLong>();
        private final Lock lock = new ReentrantLock();

        PerRoutePool() {
        }

        AtomicLong getCounter(PoolEntry<T, C> entry) {
            return this.entryMap.computeIfAbsent(entry, e -> new AtomicLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long track(PoolEntry<T, C> entry) {
            this.lock.lock();
            try {
                AtomicLong counter = this.getCounter(entry);
                long l = counter.incrementAndGet();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        PoolEntry<T, C> lease() {
            this.lock.lock();
            try {
                PoolEntry poolEntry = this.entryMap.entrySet().stream().filter(e -> {
                    HttpConnection conn = (HttpConnection)((PoolEntry)e.getKey()).getConnection();
                    return conn != null && conn.isOpen();
                }).min(Comparator.comparingLong(e -> ((AtomicLong)e.getValue()).get())).map(e -> {
                    ((AtomicLong)e.getValue()).incrementAndGet();
                    return (PoolEntry)e.getKey();
                }).orElse(null);
                return poolEntry;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long release(PoolEntry<T, C> entry, boolean reusable) {
            this.lock.lock();
            try {
                AtomicLong counter;
                if (!reusable) {
                    entry.discardConnection(CloseMode.GRACEFUL);
                }
                long l = (counter = this.entryMap.compute(entry, (e, c) -> {
                    if (c == null) {
                        return null;
                    }
                    long count = c.decrementAndGet();
                    return count > 0L ? c : null;
                })) != null ? counter.get() : 0L;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getCount(PoolEntry<T, C> entry) {
            this.lock.lock();
            try {
                AtomicLong counter = this.entryMap.get(entry);
                long l = counter == null ? 0L : counter.get();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

