/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.util.Objects;
import keycloakjar.org.apache.hc.client5.http.HttpRoute;
import keycloakjar.org.apache.hc.client5.http.SchemePortResolver;
import keycloakjar.org.apache.hc.client5.http.config.RequestConfig;
import keycloakjar.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import keycloakjar.org.apache.hc.client5.http.protocol.HttpClientContext;
import keycloakjar.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import keycloakjar.org.apache.hc.client5.http.routing.RoutingSupport;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.HttpException;
import keycloakjar.org.apache.hc.core5.http.HttpHost;
import keycloakjar.org.apache.hc.core5.http.HttpRequest;
import keycloakjar.org.apache.hc.core5.http.ProtocolException;
import keycloakjar.org.apache.hc.core5.http.URIScheme;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.apache.hc.core5.net.NamedEndpoint;
import keycloakjar.org.apache.hc.core5.net.URIAuthority;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    private static boolean sameNamedEndpoint(NamedEndpoint n1, NamedEndpoint n2) {
        if (n1 == null || n2 == null) {
            return false;
        }
        return Objects.equals(n1.getHostName(), n2.getHostName()) && n1.getPort() == n2.getPort();
    }

    @Override
    public final HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig config = clientContext.getRequestConfigOrDefault();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, context);
        }
        if ((target = RoutingSupport.normalize(host, this.schemePortResolver)).getPort() < 0) {
            throw new ProtocolException("Unroutable protocol scheme: " + target);
        }
        boolean secure = URIScheme.HTTPS.same(target.getSchemeName());
        URIAuthority authority = secure && request != null && !DefaultRoutePlanner.sameNamedEndpoint(request.getAuthority(), host) ? request.getAuthority() : null;
        InetAddress inetAddress = this.determineLocalAddress(target, context);
        if (proxy == null) {
            return new HttpRoute(target, authority, inetAddress, secure);
        }
        return new HttpRoute(target, authority, inetAddress, proxy, secure);
    }

    @Override
    public final HttpRoute determineRoute(HttpHost host, HttpContext context) throws HttpException {
        return this.determineRoute(host, null, context);
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        return null;
    }

    protected InetAddress determineLocalAddress(HttpHost firstHop, HttpContext context) throws HttpException {
        return null;
    }
}

