/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.protocol;

import java.io.IOException;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.EntityDetails;
import keycloakjar.org.apache.hc.core5.http.Header;
import keycloakjar.org.apache.hc.core5.http.HttpException;
import keycloakjar.org.apache.hc.core5.http.HttpRequest;
import keycloakjar.org.apache.hc.core5.http.HttpRequestInterceptor;
import keycloakjar.org.apache.hc.core5.http.Method;
import keycloakjar.org.apache.hc.core5.http.ProtocolException;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestValidateTrace
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestValidateTrace();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        if (Method.TRACE.isSame(request.getMethod())) {
            if (entity != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a request body.");
            }
            Header authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                throw new ProtocolException("TRACE request MUST NOT contain an Authorization header.");
            }
            Header cookieHeader = request.getHeader("Cookie");
            if (cookieHeader != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a Cookie header.");
            }
        }
    }
}

