/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.Internal;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.concurrent.FutureCallback;
import keycloakjar.org.apache.hc.core5.function.Callback;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import keycloakjar.org.apache.hc.core5.reactor.ProtocolIOSession;
import keycloakjar.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final Callback<Exception> exceptionCallback;

    public ClientH2UpgradeHandler(ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, Callback<Exception> exceptionCallback) {
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ClientH2PrefaceHandler protocolNegotiator = new ClientH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, true, callback, this.exceptionCallback);
        ioSession.upgrade(protocolNegotiator);
        try {
            protocolNegotiator.connected(ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception(ioSession, ex);
        }
    }
}

